/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts.spring;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.ListOrSet;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolver;
import com.intellij.spring.web.mvc.views.UrlBasedViewResolverFactory;
import com.intellij.spring.web.mvc.views.ViewResolver;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ThymeleafViewResolverFactory
extends UrlBasedViewResolverFactory {
    private static final String[] ourResolvers = new String[]{"org.thymeleaf.spring3.view.ThymeleafViewResolver", "org.thymeleaf.spring4.view.ThymeleafViewResolver"};

    protected boolean isMine(CommonSpringBean bean, PsiClass beanClass) {
        for (String resolverClass : ourResolvers) {
            if (!InheritanceUtil.isInheritor((PsiClass)beanClass, (String)resolverClass)) continue;
            return true;
        }
        return false;
    }

    public String getBeanClass() {
        return null;
    }

    public Set<ViewResolver> doCreate(CommonSpringBean bean, SpringModel model) {
        Module module;
        Module module2 = module = model.getModule() != null ? model.getModule() : bean.getModule();
        if (module == null) {
            return Collections.emptySet();
        }
        HashSet resolvers = new HashSet();
        PsiClass templateResolverClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.thymeleaf.templateresolver.ITemplateResolver", GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false));
        if (templateResolverClass == null) {
            return Collections.emptySet();
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)templateResolverClass).withInheritors();
        List configurers = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)searchParameters);
        if (!configurers.isEmpty()) {
            if (bean instanceof SpringBean) {
                resolvers.addAll(this.getTemplateResolvers((SpringBean)bean));
            } else {
                for (SpringBeanPointer templateResolver : configurers) {
                    resolvers.add(new UrlBasedViewResolver(templateResolver.getSpringBean()));
                }
            }
        }
        return resolvers;
    }

    @NotNull
    public Set<ViewResolver> getTemplateResolvers(@NotNull SpringBean bean) {
        CommonSpringBean templateEngine;
        SpringBeanPointer templateEngineBean;
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getTemplateResolvers"));
        }
        HashSet resolvers = new HashSet();
        SpringPropertyDefinition property = bean.getProperty("templateEngine");
        if (property instanceof SpringProperty && (templateEngineBean = (SpringBeanPointer)((SpringProperty)property).getRefAttr().getValue()) != null && (templateEngine = templateEngineBean.getSpringBean()) instanceof SpringBean) {
            SpringPropertyDefinition templateResolversProperty;
            SpringBeanPointer templateResolver;
            SpringPropertyDefinition templateResolverProperty = ((SpringBean)templateEngine).getProperty("templateResolver");
            if (templateResolverProperty instanceof SpringProperty && (templateResolver = templateResolverProperty.getRefValue()) != null) {
                resolvers.add(new UrlBasedViewResolver(templateResolver.getSpringBean()));
            }
            if ((templateResolversProperty = ((SpringBean)templateEngine).getProperty("templateResolvers")) instanceof SpringProperty) {
                for (SpringBeanPointer templateResolver2 : ThymeleafViewResolverFactory.getCollectionPointers((SpringProperty)templateResolversProperty)) {
                    resolvers.add(new UrlBasedViewResolver(templateResolver2.getSpringBean()));
                }
            }
        }
        HashSet hashSet = resolvers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getTemplateResolvers"));
        }
        return hashSet;
    }

    @NotNull
    public static Set<SpringBeanPointer> getCollectionPointers(@NotNull SpringProperty springProperty) {
        if (springProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "springProperty", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getCollectionPointers"));
        }
        LinkedHashMap beans = new LinkedHashMap();
        List listOrSets = DomUtil.getChildrenOfType((DomElement)springProperty, ListOrSet.class);
        for (ListOrSet listOrSet : listOrSets) {
            SpringPropertyUtils.addCollectionReferences((CollectionElements)listOrSet, beans);
        }
        Set<SpringBeanPointer> set = beans.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/spring/ThymeleafViewResolverFactory", "getCollectionPointers"));
        }
        return set;
    }
}

