/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.highlighter;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSCheckFunctionSignaturesInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.coffeescript.CoffeeScriptUtil;
import org.coffeescript.CsBundle;
import org.coffeescript.codeinsight.inspections.CoffeeScriptArgumentsOutsideFunctionInspection;
import org.coffeescript.highlighter.CoffeeScriptSyntaxHighlighter;
import org.coffeescript.lang.lexer.CoffeeScriptTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptAnnotatingVisitor
extends JSAnnotatingVisitor {
    final List<IElementType> OPERATOR_KEYWORDS = Arrays.asList(JSTokenTypes.ANDAND, JSTokenTypes.OROR, JSTokenTypes.EXCL, CoffeeScriptTokenTypes.EQ_EQ_EQ, CoffeeScriptTokenTypes.NOT_EQ_EQ);

    protected void initTypeCheckers(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor", "initTypeCheckers"));
        }
        this.myProblemReporter = new JSAnnotatorProblemReporter(this.myHolder);
        this.myTypeChecker = new JSTypeChecker<Annotation>(){

            public Annotation registerProblem(PsiElement place, String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                return CoffeeScriptAnnotatingVisitor.this.myProblemReporter.registerProblem(place, message, highlightType, this.getValidateTypesInspectionId(), fixes);
            }
        };
        this.myFunctionSignatureChecker = new CoffeeScriptFunctionSignatureChecker(this.myTypeChecker);
    }

    public void visitJSBinaryExpression(JSBinaryExpression node) {
        PsiElement operator;
        if (node instanceof JSBinaryExpressionImpl && (operator = ((JSBinaryExpressionImpl)node).getOperator()) != null && this.OPERATOR_KEYWORDS.contains(operator.getNode().getElementType()) && StringUtil.containsAlphaCharacters((String)operator.getText())) {
            this.myHolder.createInfoAnnotation(operator, null).setTextAttributes(CoffeeScriptSyntaxHighlighter.KEYWORD);
        }
    }

    public void visitJSPrefixExpression(JSPrefixExpression node) {
        if (this.OPERATOR_KEYWORDS.contains(node.getOperationSign())) {
            this.myHolder.createInfoAnnotation(node.getFirstChild(), null).setTextAttributes(CoffeeScriptSyntaxHighlighter.KEYWORD);
        }
    }

    protected boolean needsInitializer(JSParameter parameter) {
        return false;
    }

    protected Annotation reportUnresolvedRefProblem(ProblemHighlightType unresolveReferenceHighlightType, List<LocalQuickFix> quickFixes, PsiElement referenceNameElement, String message, String inspectionId) {
        return super.reportUnresolvedRefProblem(unresolveReferenceHighlightType, Collections.emptyList(), referenceNameElement, message, inspectionId);
    }

    protected void checkCallReferences(JSCallExpression node, JSReferenceExpression referenceExpression) {
        ResolveResult[] resolveResults = referenceExpression.multiResolve(false);
        if (resolveResults.length != 1 || !(resolveResults[0].getElement() instanceof JSVariable) || referenceExpression.getQualifier() != null) {
            super.checkCallReferences(node, referenceExpression);
        }
    }

    public void visitJSParameter(JSParameter node) {
        JSFunction function;
        super.visitJSParameter(node);
        if (node.getText().startsWith("@") && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunctionExpression.class)) != null && CoffeeScriptUtil.canHoldImplicitProperties(function)) {
            this.myHolder.createInfoAnnotation(node.getLastChild(), null).setTextAttributes(CoffeeScriptSyntaxHighlighter.GLOBAL_VARIABLE);
        }
    }

    public void visitJSReturnStatement(JSReturnStatement node) {
    }

    public void visitJSReferenceExpression(JSReferenceExpression node) {
        if (!CoffeeScriptArgumentsOutsideFunctionInspection.argumentsOutsideFunction(node)) {
            super.visitJSReferenceExpression(node);
        }
    }

    private class CoffeeScriptFunctionSignatureChecker
    extends JSFunctionSignatureChecker {
        public CoffeeScriptFunctionSignatureChecker(JSTypeChecker typeChecker) {
            super(typeChecker);
        }

        protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
            PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem((JSCallExpression)callExpression, (JSArgumentList)callExpression.getArgumentList());
            CoffeeScriptAnnotatingVisitor.this.myProblemReporter.registerProblem(place, message, null, JSCheckFunctionSignaturesInspection.SHORT_NAME, fixes);
        }

        public void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
            JSClass clazz;
            JSFunction constructor;
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor$CoffeeScriptFunctionSignatureChecker", "checkFunction"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/highlighter/CoffeeScriptAnnotatingVisitor$CoffeeScriptFunctionSignatureChecker", "checkFunction"));
            }
            if (element instanceof JSClass && (constructor = (clazz = (JSClass)element).getConstructor()) != null) {
                int mandatoryParameters = constructor.getParameters().length;
                for (JSParameter parameter : constructor.getParameters()) {
                    if (!parameter.isOptional()) continue;
                    --mandatoryParameters;
                }
                this.reportProblemIfNotExpectedCountOfParameters(node, mandatoryParameters, constructor.getParameters().length);
            }
        }

        public void reportProblemIfNotExpectedCountOfParameters(JSCallExpression node, int minCount, int maxCount) {
            JSExpression[] arguments = node.getArguments();
            if (arguments.length < minCount || arguments.length > maxCount) {
                if (minCount == maxCount) {
                    this.registerProblem(node, JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{minCount}), new LocalQuickFix[0]);
                } else {
                    this.registerProblem(node, CsBundle.message("inspection.invalid.number.of.parameters.range", minCount, maxCount), new LocalQuickFix[0]);
                }
            }
        }

        protected void checkCallParameters(JSCallExpression call, @Nullable PsiElement element) {
            JSArgumentList argumentList;
            if (element instanceof JSFunction) {
                for (JSParameter parameter : ((JSFunction)element).getParameters()) {
                    if (parameter.getNode().findChildByType(CoffeeScriptTokenTypes.SPLAT) == null) continue;
                    return;
                }
            }
            if ((argumentList = call.getArgumentList()) != null && argumentList.getNode().findChildByType(CoffeeScriptTokenTypes.SPLAT) != null) {
                return;
            }
            super.checkCallParameters(call, element);
        }
    }
}

