/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.lang.injection;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.coffeescript.CoffeeScriptDocStringUtil;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptInjectionUtil {
    public static void doInjection(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element, @NotNull Language language) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/coffeescript/lang/injection/CoffeeScriptInjectionUtil", "doInjection"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/injection/CoffeeScriptInjectionUtil", "doInjection"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/coffeescript/lang/injection/CoffeeScriptInjectionUtil", "doInjection"));
        }
        List<TextRange> ranges = CoffeeScriptDocStringUtil.getDocStringValue(element.getText());
        registrar = registrar.startInjecting(language);
        for (TextRange range : ranges) {
            registrar = registrar.addPlace(null, null, (PsiLanguageInjectionHost)element, range);
        }
        registrar.doneInjecting();
        XmlHighlightVisitor.setSkipValidation((PsiElement)element);
    }

    public static boolean willInjectSql(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/lang/injection/CoffeeScriptInjectionUtil", "willInjectSql"));
        }
        String text = element.getText().trim().toLowerCase();
        return text.contains("select") && text.contains("from") || text.contains("update") && text.contains("set") && PsiTreeUtil.getChildrenOfType((PsiElement)element, OuterLanguageElement.class) == null;
    }
}

