/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.run;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.JBCheckBox;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationParametersProvider;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.coffeescript.lang.psi.CoffeeScriptFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoffeeScriptNodeJSRunConfigurationParametersProvider
implements NodeJSRunConfigurationParametersProvider {
    private static final String ATTRIBUTE_COFFEE_SCRIPT_PATH = "coffeescript-path";
    private static final String ATTRIBUTE_COFFEE_SCRIPT_RUN = "coffeescript-run";
    private static final String ATTRIBUTE_COFFEE_SCRIPT_PARAMS = "coffeescript-params";
    private static final String DEFAULT_VALUE = "";

    public JComponent getParameterEditorComponent(@Nullable Project project) {
        return new CoffeeScriptParameterEditor(project);
    }

    public void checkConfiguration(@NotNull Object value) throws RuntimeConfigurationException {
        String coffeePathProblems;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "checkConfiguration"));
        }
        CoffeeScriptNodeJSParameters parameters = (CoffeeScriptNodeJSParameters)value;
        if (parameters.isEnabled() && (coffeePathProblems = CoffeeScriptNodeJSRunConfigurationParametersProvider.checkCoffeePath(parameters.getPathToCoffee())) != null) {
            throw new RuntimeConfigurationException(coffeePathProblems);
        }
    }

    public void reset(@NotNull JComponent editor, @Nullable Object value) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "reset"));
        }
        CoffeeScriptParameterEditor coffeeScriptParameterEditor = (CoffeeScriptParameterEditor)editor;
        CoffeeScriptNodeJSParameters parameters = value != null ? (CoffeeScriptNodeJSParameters)value : CoffeeScriptNodeJSParameters.DEFAULT_INSTANCE;
        coffeeScriptParameterEditor.getEnabledCoffeeCheckBox().setSelected(parameters.isEnabled());
        coffeeScriptParameterEditor.setEnableForInnerComponents(parameters.isEnabled());
        coffeeScriptParameterEditor.getPathToCoffee().getTextField().setText(parameters.getPathToCoffee());
        coffeeScriptParameterEditor.getCoffeeParametersTextField().setText(parameters.getCoffeeParams());
    }

    public Object getValue(@NotNull JComponent editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "getValue"));
        }
        CoffeeScriptParameterEditor coffeeScriptParameterEditor = (CoffeeScriptParameterEditor)editor;
        return new CoffeeScriptNodeJSParameters(coffeeScriptParameterEditor.getPathToCoffee().getText(), coffeeScriptParameterEditor.getCoffeeParametersTextField().getText(), coffeeScriptParameterEditor.getEnabledCoffeeCheckBox().isSelected());
    }

    public void writeExternal(@NotNull Element element, @NotNull Object value) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "writeExternal"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "writeExternal"));
        }
        CoffeeScriptNodeJSParameters parameters = (CoffeeScriptNodeJSParameters)value;
        if (!parameters.equals(CoffeeScriptNodeJSParameters.DEFAULT_INSTANCE)) {
            String coffeeParams;
            String pathToCoffee = parameters.getPathToCoffee();
            if (!pathToCoffee.isEmpty()) {
                element.setAttribute(ATTRIBUTE_COFFEE_SCRIPT_PATH, pathToCoffee);
            }
            if (parameters.isEnabled()) {
                element.setAttribute(ATTRIBUTE_COFFEE_SCRIPT_RUN, Boolean.toString(parameters.isEnabled()));
            }
            if (!(coffeeParams = parameters.getCoffeeParams()).isEmpty()) {
                element.setAttribute(ATTRIBUTE_COFFEE_SCRIPT_PARAMS, coffeeParams);
            }
        }
    }

    public Object readExternal(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "readExternal"));
        }
        String pathToCoffee = CoffeeScriptNodeJSRunConfigurationParametersProvider.getAttributeValue(element, ATTRIBUTE_COFFEE_SCRIPT_PATH);
        String coffeeScriptParams = CoffeeScriptNodeJSRunConfigurationParametersProvider.getAttributeValue(element, ATTRIBUTE_COFFEE_SCRIPT_PARAMS);
        String coffeeScriptRun = CoffeeScriptNodeJSRunConfigurationParametersProvider.getAttributeValue(element, ATTRIBUTE_COFFEE_SCRIPT_RUN);
        return new CoffeeScriptNodeJSParameters(pathToCoffee, coffeeScriptParams, Boolean.parseBoolean(coffeeScriptRun));
    }

    @NotNull
    private static String getAttributeValue(@NotNull Element element, @NotNull String key) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "getAttributeValue"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "getAttributeValue"));
        }
        String string = StringUtil.notNullize((String)element.getAttributeValue(key));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "getAttributeValue"));
        }
        return string;
    }

    public void processCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull Object value) {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "processCommandLine"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "processCommandLine"));
        }
        CoffeeScriptNodeJSParameters parameters = (CoffeeScriptNodeJSParameters)value;
        if (parameters.isEnabled()) {
            if (!SystemInfo.isWindows) {
                commandLine.setExePath(parameters.getPathToCoffee());
                commandLine.addParameters(ParametersList.parse((String)parameters.getCoffeeParams()));
            } else {
                commandLine.addParameter(parameters.getPathToCoffee());
            }
        }
    }

    public boolean changeExecutableCommand(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "changeExecutableCommand"));
        }
        CoffeeScriptNodeJSParameters parameters = (CoffeeScriptNodeJSParameters)value;
        if (parameters.isEnabled()) {
            return !SystemInfo.isWindows;
        }
        return false;
    }

    public void adjustForFile(@NotNull Object value, @NotNull PsiFile file) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "adjustForFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "adjustForFile"));
        }
        if (file instanceof CoffeeScriptFile) {
            CoffeeScriptNodeJSParameters parameters = (CoffeeScriptNodeJSParameters)value;
            parameters.setEnabled(true);
        }
    }

    public Object cloneValue(@Nullable Object value) {
        if (value == null) {
            value = CoffeeScriptNodeJSParameters.DEFAULT_INSTANCE;
        }
        CoffeeScriptNodeJSParameters params = (CoffeeScriptNodeJSParameters)value;
        return new CoffeeScriptNodeJSParameters(params.pathToCoffee, params.coffeeParams, params.enabled);
    }

    public boolean isEnabled(@Nullable Object value) {
        if (value instanceof CoffeeScriptNodeJSParameters) {
            CoffeeScriptNodeJSParameters parameters = (CoffeeScriptNodeJSParameters)value;
            return parameters.isEnabled();
        }
        return false;
    }

    @Nullable
    private static String checkCoffeePath(@NotNull String pathToCoffee) {
        if (pathToCoffee == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToCoffee", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider", "checkCoffeePath"));
        }
        if (pathToCoffee.isEmpty()) {
            return "Path to CoffeeScript executable is empty";
        }
        File file = new File(pathToCoffee);
        if (!file.exists() || file.isDirectory()) {
            return "Path to CoffeeScript is not correct";
        }
        return null;
    }

    private static class CoffeeScriptNodeJSParameters {
        public static final CoffeeScriptNodeJSParameters DEFAULT_INSTANCE = new CoffeeScriptNodeJSParameters("", "", false);
        private final String pathToCoffee;
        private final String coffeeParams;
        private boolean enabled;

        private CoffeeScriptNodeJSParameters(@NotNull String pathToCoffee, @NotNull String coffeeParams, boolean enabled) {
            if (pathToCoffee == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToCoffee", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider$CoffeeScriptNodeJSParameters", "<init>"));
            }
            if (coffeeParams == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coffeeParams", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider$CoffeeScriptNodeJSParameters", "<init>"));
            }
            this.pathToCoffee = pathToCoffee;
            this.coffeeParams = coffeeParams;
            this.enabled = enabled;
        }

        @NotNull
        public String getPathToCoffee() {
            String string = this.pathToCoffee;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider$CoffeeScriptNodeJSParameters", "getPathToCoffee"));
            }
            return string;
        }

        @NotNull
        public String getCoffeeParams() {
            String string = this.coffeeParams;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/coffeescript/run/CoffeeScriptNodeJSRunConfigurationParametersProvider$CoffeeScriptNodeJSParameters", "getCoffeeParams"));
            }
            return string;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoffeeScriptNodeJSParameters parameter = (CoffeeScriptNodeJSParameters)o;
            if (this.enabled != parameter.enabled) {
                return false;
            }
            if (!this.coffeeParams.equals(parameter.coffeeParams)) {
                return false;
            }
            return this.pathToCoffee.equals(parameter.pathToCoffee);
        }

        public int hashCode() {
            int result = this.pathToCoffee.hashCode();
            result = 31 * result + this.coffeeParams.hashCode();
            result = 31 * result + (this.enabled ? 1 : 0);
            return result;
        }

        public void setEnabled(boolean b) {
            this.enabled = b;
        }
    }

    private static class CoffeeScriptParameterEditor
    extends JPanel {
        private final TextFieldWithBrowseButton pathToCoffee;
        private final JTextField coffeeParameters;
        private final JBCheckBox enabledCoffeeCheckBox;
        private final JLabel labelForCoffeePath = new JLabel("Path to coffee executable:");
        private final JLabel labelForCoffeeParams;

        public CoffeeScriptParameterEditor(@Nullable Project project) {
            super(new GridBagLayout());
            this.pathToCoffee = new TextFieldWithBrowseButton();
            this.enabledCoffeeCheckBox = new JBCheckBox("Run with CoffeeScript plugin");
            this.coffeeParameters = new JTextField();
            this.labelForCoffeeParams = new JLabel("CoffeeScript parameters:");
            this.labelForCoffeePath.setEnabled(false);
            this.pathToCoffee.setEnabled(false);
            this.enabledCoffeeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CoffeeScriptParameterEditor.this.setEnableForInnerComponents(CoffeeScriptParameterEditor.this.enabledCoffeeCheckBox.isSelected());
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridwidth = 2;
            this.add((Component)this.enabledCoffeeCheckBox, c);
            c = (GridBagConstraints)c.clone();
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            this.add((Component)this.labelForCoffeePath, c);
            this.pathToCoffee.getTextField().setEditable(true);
            this.pathToCoffee.addBrowseFolderListener("Select path to executable CoffeeScript file", "It will be used to run CoffeeScript files", project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 10.0;
            c.fill = 2;
            c.anchor = 17;
            this.add((Component)this.pathToCoffee, c);
            c = new GridBagConstraints();
            c.gridy = 2;
            c.anchor = 17;
            this.add((Component)this.labelForCoffeeParams, c);
            c = (GridBagConstraints)c.clone();
            c.gridx = 1;
            c.weightx = 10.0;
            c.fill = 2;
            this.add((Component)this.coffeeParameters, c);
        }

        public TextFieldWithBrowseButton getPathToCoffee() {
            return this.pathToCoffee;
        }

        public JCheckBox getEnabledCoffeeCheckBox() {
            return this.enabledCoffeeCheckBox;
        }

        public JTextField getCoffeeParametersTextField() {
            return this.coffeeParameters;
        }

        public void setEnableForInnerComponents(boolean enabled) {
            this.labelForCoffeePath.setEnabled(enabled);
            this.pathToCoffee.setEnabled(enabled);
            this.labelForCoffeeParams.setEnabled(enabled);
            this.coffeeParameters.setEnabled(enabled);
        }
    }
}

