/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.grails.rt;

import grails.build.GrailsBuildListener;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class GrailsIdeaTestListener
implements GrailsBuildListener {
    private final Map myProperties = new HashMap();
    private String myClassName;
    private PrintStream out;

    public void receiveGrailsBuildEvent(String s, Object[] objects) {
        if (this.out == null) {
            this.out = System.out;
        }
        if ("TestCaseEnd".equals(s)) {
            this.out.println(objects[1]);
            this.testSuiteFinished((String)objects[0]);
        } else if ("TestCaseStart".equals(s)) {
            this.myClassName = (String)objects[0];
            this.testSuiteStarted(this.myClassName);
        } else if ("TestStart".equals(s)) {
            this.testStarted((String)objects[0]);
        } else if ("TestEnd".equals(s)) {
            this.testFinished((String)objects[0]);
        } else if ("TestFailure".equals(s)) {
            Object failure = objects[1];
            String message = failure instanceof Throwable ? GrailsIdeaTestListener.replaceEscapedSymbols(((Throwable)failure).getMessage()) : String.valueOf(failure);
            String details = failure instanceof Throwable ? GrailsIdeaTestListener.getStackTrace((Throwable)failure) : "none";
            String error = failure instanceof AssertionError || failure == null ? "error='true'" : "";
            this.out.println("\n##teamcity[testFailed name='" + GrailsIdeaTestListener.replaceEscapedSymbols((String)objects[0]) + "' message='" + message + "' details='" + details + "' " + error + "]");
        }
    }

    private static String replaceEscapedSymbols(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("[\\|'\\[\\]]", "\\|$0").replaceAll("\n", "|n").replaceAll("\r", "|r");
    }

    static String getStackTrace(Throwable e) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        return GrailsIdeaTestListener.replaceEscapedSymbols(writer.getBuffer().toString());
    }

    private void testFinished(String testName) {
        long duration = System.currentTimeMillis() - (Long)this.myProperties.get(testName);
        this.out.println("\n##teamcity[testFinished name='" + GrailsIdeaTestListener.replaceEscapedSymbols(testName) + "' duration='" + duration + "']");
    }

    private void testStarted(String testName) {
        String testLocation = GrailsIdeaTestListener.replaceEscapedSymbols(this.myClassName + '.' + testName);
        this.out.println("\n##teamcity[testStarted name='" + GrailsIdeaTestListener.replaceEscapedSymbols(testName) + "' captureStandardOutput='false' locationHint='grails://methodName::" + testLocation + "']");
        this.myProperties.put(testName, new Long(System.currentTimeMillis()));
    }

    private void testSuiteStarted(String name) {
        this.out.println("\n##teamcity[testSuiteStarted name='" + name + "' locationHint='grails://className::" + name + "']");
        this.myProperties.put(name, new Long(System.currentTimeMillis()));
    }

    private void testSuiteFinished(String name) {
        long duration = System.currentTimeMillis() - (Long)this.myProperties.get(name);
        this.out.println("\n##teamcity[testSuiteFinished name='" + name + "' duration='" + duration + "']");
    }
}

