/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.oss.glassfish.GlassfishBundle;
import com.intellij.javaee.oss.glassfish.server.GlassfishLocalEditor;
import com.intellij.javaee.oss.glassfish.server.GlassfishPortConfig;
import com.intellij.javaee.oss.glassfish.server.GlassfishSecuredConfig;
import com.intellij.javaee.oss.glassfish.server.GlassfishServerModel;
import com.intellij.javaee.oss.glassfish.server.GlassfishVirtualServersConfig;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class GlassfishLocalModel
extends GlassfishServerModel {
    public String DOMAIN = "";

    GlassfishLocalModel() {
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new GlassfishLocalEditor();
    }

    public int getLocalPort() {
        return GlassfishPortConfig.getLocal(this);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (StringUtil.isEmpty((String)this.DOMAIN)) {
            throw new RuntimeConfigurationError(GlassfishBundle.getText("GlassfishLocalModel.error.missing", new Object[0]));
        }
        if (this.getServerPort() == Integer.MAX_VALUE) {
            throw new RuntimeConfigurationError(GlassfishBundle.getText("GlassfishLocalModel.error.invalid", new Object[0]));
        }
        if (this.getServerPort() <= 0) {
            throw new RuntimeConfigurationError(GlassfishBundle.getText("GlassfishLocalModel.error.disabled", new Object[0]));
        }
        super.checkConfiguration();
    }

    protected int getServerPort() {
        return GlassfishPortConfig.getAdmin(this);
    }

    @Nullable
    protected String getLogFilePath(String home) {
        if (!StringUtil.isEmpty((String)home) && !StringUtil.isEmpty((String)this.DOMAIN)) {
            return new File(this.getBaseDir(), FileUtil.toSystemDependentName((String)("domains/" + this.DOMAIN + "/logs/server.log"))).getAbsolutePath();
        }
        return null;
    }

    public List<String> getDomains() {
        ArrayList<String> domains = new ArrayList<String>();
        File[] files = new File(this.getBaseDir(), "domains").listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                domains.add(file.getName());
            }
        }
        return domains;
    }

    public List<String> getVirtualServers() {
        return GlassfishVirtualServersConfig.get(this);
    }

    @Override
    public String getVirtualServer() {
        String virtualServer = super.getVirtualServer();
        return this.getVirtualServers().contains(virtualServer) ? virtualServer : null;
    }

    public File getScript() {
        String script = SystemInfo.isWindows ? "asadmin.bat" : "asadmin";
        return new File(this.getBaseDir(), FileUtil.toSystemDependentName((String)("bin/" + script)));
    }

    public File getBaseDir() {
        return this.isGlassfish3Plus() ? new File(this.getHome(), "glassfish") : new File(this.getHome());
    }

    @Override
    protected boolean isSecured() {
        return GlassfishSecuredConfig.get(this);
    }
}

