/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.javaee.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.context.FacetContextProvider;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.javaee.web.WebFacetContextProvider;
import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Url;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatModuleDeploymentModel;

public class TomcatUrlMapping
extends ApplicationServerUrlMapping {
    public static final TomcatUrlMapping INSTANCE = new TomcatUrlMapping();

    private TomcatUrlMapping() {
    }

    protected void collectFacetContextProviders(List<FacetContextProvider> facetContextProvider) {
        facetContextProvider.add((FacetContextProvider)new WebFacetContextProvider());
    }

    public VirtualFile findSourceFile(@NotNull J2EEServerInstance serverInstance, @NotNull CommonModel commonModel, @NotNull Url url) {
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "org/jetbrains/idea/tomcat/TomcatUrlMapping", "findSourceFile"));
        }
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "org/jetbrains/idea/tomcat/TomcatUrlMapping", "findSourceFile"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/tomcat/TomcatUrlMapping", "findSourceFile"));
        }
        String baseUrl = ApplicationServerUrlMapping.createUrl((CommonModel)commonModel, null, null);
        String urlString = url.trimParameters().toDecodedForm();
        if (!urlString.startsWith(baseUrl)) {
            return null;
        }
        String relative = StringUtil.trimStart((String)urlString.substring(baseUrl.length()), (String)"/");
        return WebUtil.findSourceFile((String)relative, (CommonModel)commonModel, (Function)new Function<DeploymentModel, String>(){

            public String fun(DeploymentModel model) {
                TomcatModuleDeploymentModel tomcatModel = (TomcatModuleDeploymentModel)model;
                return tomcatModel.isEEArtifact() ? null : tomcatModel.CONTEXT_PATH;
            }
        });
    }
}

