/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor;

import com.intellij.javaee.oss.jboss.model.JBossCmpBean;
import com.intellij.javaee.oss.jboss.model.JBossLoadGroup;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.sql.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public class JBossDataFactory {
    @NonNls
    private static final String[] MAPPINGS = JBossDataFactory.createMappings("FirstSQL/J", "Ingres", "McKoi", "Firebird", "InterBase", "DB2", "Derby", "Oracle9i", "Oracle8", "Oracle7", "Sybase", "PostgreSQL", "PostgreSQL 8.0", "PostgreSQL 7.2", "Hypersonic SQL", "PointBase", "SOLID", "mySQL", "MS SQLSERVER", "MS SQLSERVER2000", "DB2/400", "SapDB", "Cloudscape", "InformixDB", "Mimer SQL");
    private static final String[] TYPES = JBossDataFactory.createTypes();

    private JBossDataFactory() {
    }

    public static String[] getMappings() {
        return MAPPINGS;
    }

    public static String[] getTypes() {
        return TYPES;
    }

    public static String[] getLoadGroups(JBossCmpBean cmp) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("*");
        for (JBossLoadGroup group : cmp.getLoadGroups().getLoadGroups()) {
            list.add(group.getLoadGroupName().getValue());
        }
        list.add(null);
        return ArrayUtil.toStringArray(list);
    }

    public static Factory<List<Pair<String, Icon>>> getFactory(final String[] values) {
        return new Factory<List<Pair<String, Icon>>>(){

            public List<Pair<String, Icon>> create() {
                return ContainerUtil.map2List((Object[])values, (Function)Pair.createFunction(null));
            }
        };
    }

    private static String[] createMappings(String ... mappings) {
        ArrayList<Object> list = new ArrayList<Object>();
        ContainerUtil.addAll(list, (Object[])mappings);
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        list.add(null);
        return ArrayUtil.toStringArray(list);
    }

    private static String[] createTypes() {
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : Types.class.getFields()) {
            list.add(field.getName());
        }
        list.add(null);
        return ArrayUtil.toStringArray(list);
    }
}

