/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AsyncUpdateAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.CancelActionException;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4File;

public abstract class ActionBaseFile
extends AsyncUpdateAction<VcsContext>
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.actions.ActionBaseFile");
    protected static final String[] YES_NO_OPTIONS = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()};
    protected static final String[] YES_NO_CANCELREST_OPTIONS = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), PerforceBundle.message((String)"button.text.cancel.rest", (Object[])new Object[0])};

    protected static void log(@NonNls String msg) {
        LOG.debug(msg);
    }

    protected VcsContext prepareDataFromContext(AnActionEvent e) {
        return VcsContextFactory.SERVICE.getInstance().createCachedContextOn(e);
    }

    protected void performUpdate(Presentation presentation, VcsContext context) {
        Project project = context.getProject();
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        VirtualFile[] vFiles = context.getSelectedFiles();
        List<VirtualFile> nonIgnored = ActionBaseFile.findNonIgnoredFiles(project, vFiles);
        presentation.setEnabled(!nonIgnored.isEmpty());
    }

    private static List<VirtualFile> findNonIgnoredFiles(final Project project, VirtualFile[] vFiles) {
        final ArrayList nonIgnored = ContainerUtil.newArrayList();
        for (VirtualFile file : vFiles) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/actions/ActionBaseFile$1", "visitFile"));
                    }
                    if (FileStatusManager.getInstance((Project)project).getStatus(file) != FileStatus.IGNORED) {
                        nonIgnored.add(file);
                    }
                    return true;
                }
            });
        }
        return nonIgnored;
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    protected abstract void performAction(VirtualFile var1, Project var2, boolean var3, boolean var4, List<VirtualFile> var5) throws CancelActionException, VcsException;

    public void actionPerformed(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
            }
        });
        VirtualFile[] vFiles = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)PerforceVcs.getInstance(project), vFiles)) {
            return;
        }
        this.processFiles(project, vFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFiles(Project project, VirtualFile ... vFiles) {
        block15: {
            boolean containsDirectory = false;
            if (vFiles != null && vFiles.length > 0) {
                block14: {
                    try {
                        ArrayList<VirtualFile> filesToPostProcess = new ArrayList<VirtualFile>();
                        VirtualFile[] virtualFileArray = vFiles;
                        int n = virtualFileArray.length;
                        for (int i = 0; i < n; ++i) {
                            VirtualFile vFile = virtualFileArray[i];
                            boolean[] cancelled = new boolean[]{false};
                            try {
                                try {
                                    this.performAction(vFile, project, true, vFiles.length == 1, filesToPostProcess);
                                    if (vFile.isDirectory()) {
                                        containsDirectory = true;
                                    }
                                }
                                catch (VcsException e) {
                                    AbstractVcsHelper.getInstance((Project)project).showError(e, PerforceBundle.message((String)"dialog.title.perforce", (Object[])new Object[0]));
                                }
                            }
                            catch (CancelActionException e) {
                                cancelled[0] = true;
                            }
                            if (cancelled[0]) break;
                        }
                        this.postProcessFiles(project, filesToPostProcess);
                        if (!containsDirectory) break block14;
                    }
                    catch (Throwable throwable) {
                        if (containsDirectory) {
                            VirtualFileManager.getInstance().asyncRefresh(new Runnable(project, vFiles){
                                final /* synthetic */ Project val$project;
                                final /* synthetic */ VirtualFile[] val$vFiles;
                                {
                                    this.val$project = project;
                                    this.val$vFiles = virtualFileArray;
                                }

                                @Override
                                public void run() {
                                    P4File.invalidateFstat(this.val$project);
                                    for (VirtualFile file : this.val$vFiles) {
                                        if (file.isDirectory()) {
                                            VcsDirtyScopeManager.getInstance((Project)this.val$project).dirDirtyRecursively(file);
                                            continue;
                                        }
                                        VcsDirtyScopeManager.getInstance((Project)this.val$project).fileDirty(file);
                                    }
                                }
                            });
                        } else {
                            for (VirtualFile vFile : vFiles) {
                                ApplicationManager.getApplication().runWriteAction(new Runnable(vFile){
                                    final /* synthetic */ VirtualFile val$vFile;
                                    {
                                        this.val$vFile = virtualFile;
                                    }

                                    @Override
                                    public void run() {
                                        this.val$vFile.refresh(false, false);
                                    }
                                });
                                P4File.invalidateFstat(vFile);
                                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(vFile);
                            }
                        }
                        throw throwable;
                    }
                    VirtualFileManager.getInstance().asyncRefresh(new /* invalid duplicate definition of identical inner class */);
                    break block15;
                }
                for (VirtualFile vFile : vFiles) {
                    ApplicationManager.getApplication().runWriteAction(new /* invalid duplicate definition of identical inner class */);
                    P4File.invalidateFstat(vFile);
                    VcsDirtyScopeManager.getInstance((Project)project).fileDirty(vFile);
                }
            }
        }
    }

    public void postProcessFiles(Project project, List<VirtualFile> filesToPostProcess) {
    }
}

