/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.jobs.EditChangelistJobsDialog;
import org.jetbrains.idea.perforce.perforce.jobs.JobDetailsLoader;
import org.jetbrains.idea.perforce.perforce.jobs.P4JobsLogicConn;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;

public class LinkChangeListToJobsAction
extends AnAction {
    public void update(AnActionEvent e) {
        e.getPresentation().setText(PerforceBundle.message((String)"action.link.changelist.to.jobs", (Object[])new Object[0]));
        if (!LinkChangeListToJobsAction.enabled(e)) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(true);
    }

    private static boolean enabled(AnActionEvent e) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null || project.isDefault()) {
            return false;
        }
        if (!PerforceSettings.getSettings((Project)project).ENABLED) {
            return false;
        }
        if (!PerforceSettings.getSettings((Project)project).USE_PERFORCE_JOBS) {
            return false;
        }
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        if (lists == null || lists.length != 1) {
            return false;
        }
        return !PerforceNumberNameSynchronizer.getInstance(project).getAllNumbers(lists[0].getName()).isEmpty();
    }

    public void actionPerformed(AnActionEvent e) {
        if (!LinkChangeListToJobsAction.enabled(e)) {
            return;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        ChangeList[] lists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        assert (lists != null);
        LocalChangeList list = (LocalChangeList)lists[0];
        JobDetailsLoader loader = new JobDetailsLoader(project);
        HashMap<ConnectionKey, P4JobsLogicConn> connMap = new HashMap<ConnectionKey, P4JobsLogicConn>();
        HashMap<ConnectionKey, List<PerforceJob>> perforceJobs = new HashMap<ConnectionKey, List<PerforceJob>>();
        loader.loadJobsForList(list, connMap, perforceJobs);
        if (perforceJobs.isEmpty()) {
            Messages.showInfoMessage((String)"No valid Perforce connections found, please check your VCS root configuration", (String)"Perforce");
            return;
        }
        new EditChangelistJobsDialog(project, list, false, connMap, perforceJobs).show();
    }
}

