/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.AnnotationProviderEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceFileRevision;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.application.annotation.AnnotationInfo;
import org.jetbrains.idea.perforce.application.annotation.PerforceFileAnnotation;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.P4Revision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceAnnotationProvider
implements AnnotationProviderEx {
    private final Project myProject;
    private final PerforceRunner myRunner;

    public PerforceAnnotationProvider(Project project) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(project);
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "annotate"));
        }
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
        FileAnnotation fileAnnotation = this.doAnnotate(file, ChangesUtil.getCommittedPath((Project)this.myProject, (FilePath)filePath), -1L);
        if (fileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "annotate"));
        }
        return fileAnnotation;
    }

    @NotNull
    private FileAnnotation doAnnotate(VirtualFile vFile, FilePath file, long changeNumber) throws VcsException {
        P4Connection connection = PerforceSettings.getSettings(this.myProject).getConnectionForFile(vFile);
        if (connection == null) {
            throw new VcsException("Invalid Perforce settings");
        }
        FileAnnotation fileAnnotation = this.doAnnotate(changeNumber, connection, P4File.create(file).getEscapedPath()).createAnnotation(vFile);
        if (fileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "doAnnotate"));
        }
        return fileAnnotation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private AnnotationPrecursor doAnnotate(final long changeNumber, P4Connection connection, @NotNull String string) throws VcsException {
        void path;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "doAnnotate"));
        }
        Object[] fileLog = this.myRunner.filelog(connection, (String)path, true);
        P4Revision p4Revision = (P4Revision)ContainerUtil.find((Object[])fileLog, (Condition)new Condition<P4Revision>(){

            public boolean value(P4Revision p4Revision1) {
                return p4Revision1.getChangeNumber() == changeNumber;
            }
        });
        String pathAtRevision = p4Revision == null ? path : p4Revision.getDepotPath();
        long revision = p4Revision == null ? -1L : p4Revision.getRevisionNumber();
        AnnotationInfo annotationInfo = this.myRunner.annotate(connection, pathAtRevision, revision);
        AnnotationPrecursor annotationPrecursor = new AnnotationPrecursor(annotationInfo, (P4Revision[])fileLog, revision, p4Revision, connection);
        if (annotationPrecursor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "doAnnotate"));
        }
        return annotationPrecursor;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull VirtualFile file, VcsFileRevision revision) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "annotate"));
        }
        PerforceVcsRevisionNumber number = (PerforceVcsRevisionNumber)revision.getRevisionNumber();
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
        FileAnnotation fileAnnotation = this.doAnnotate(file, filePath, number.getChangeNumber());
        if (fileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "annotate"));
        }
        return fileAnnotation;
    }

    @NotNull
    public FileAnnotation annotate(@NotNull FilePath path, @NotNull VcsRevisionNumber number) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "annotate"));
        }
        if (number == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "number", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "annotate"));
        }
        PerforceSettings settings = PerforceSettings.getSettings(this.myProject);
        P4Connection connection = settings.getConnectionForFile(path.getIOFile());
        if (connection == null) {
            throw new VcsException("Cannot find Perforce root for " + path);
        }
        long changeNumber = ((PerforceVcsRevisionNumber)number).getChangeNumber();
        AnnotationPrecursor precursor = this.doAnnotate(changeNumber, connection, ((PerforceVcsRevisionNumber)number).getDepotPath());
        if (precursor.p4Revision == null) {
            throw new VcsException("Cannot find Perforce revision " + changeNumber + " for " + path);
        }
        PerforceFileRevision revision = new PerforceFileRevision(precursor.p4Revision, connection, this.myProject);
        FileAnnotation fileAnnotation = precursor.createAnnotation((VirtualFile)new VcsVirtualFile(path.getPath(), (VcsFileRevision)revision, (VirtualFileSystem)VcsFileSystem.getInstance()));
        if (fileAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "annotate"));
        }
        return fileAnnotation;
    }

    public boolean isAnnotationValid(@NotNull VcsFileRevision rev) {
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider", "isAnnotationValid"));
        }
        return true;
    }

    private class AnnotationPrecursor {
        final AnnotationInfo info;
        final P4Revision[] fileLog;
        final long changeNumber;
        @Nullable
        final P4Revision p4Revision;
        final P4Connection connection;

        AnnotationPrecursor(AnnotationInfo info, P4Revision[] fileLog, @Nullable long changeNumber, P4Revision p4Revision, P4Connection connection) {
            this.info = info;
            this.fileLog = fileLog;
            this.changeNumber = changeNumber;
            this.p4Revision = p4Revision;
            this.connection = connection;
        }

        FileAnnotation createAnnotation(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/application/PerforceAnnotationProvider$AnnotationPrecursor", "createAnnotation"));
            }
            return new PerforceFileAnnotation(this.info, file, this.fileLog, PerforceAnnotationProvider.this.myProject, this.connection, this.changeNumber);
        }
    }
}

