/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceNameCommentConvertor;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

class PerforceChangeListCalculator {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceChangeListCalculator");
    private final ChangeListManagerGate myAddGate;
    private final PerforceNumberNameSynchronizer mySynchronizer;
    private final ConnectionKey myConnectionKey;

    PerforceChangeListCalculator(Project project, P4Connection connection, ChangeListManagerGate addGate) throws VcsException {
        this.myConnectionKey = connection.getConnectionKey();
        this.myAddGate = addGate;
        this.mySynchronizer = PerforceNumberNameSynchronizer.getInstance(project);
    }

    ChangeList convert(PerforceChange perforceChange) throws VcsException {
        long changeListNumber = perforceChange.getChangeList();
        String name = this.mySynchronizer.getName(this.myConnectionKey, changeListNumber);
        if (name != null) {
            return this.myAddGate.findChangeList(name);
        }
        return this.findOrCreate(changeListNumber, perforceChange.getChangeListDescription(), this.myAddGate);
    }

    private ChangeList findOrCreate(long p4number, String changeListDescription, ChangeListManagerGate addGate) throws VcsException {
        String name;
        LocalChangeList changeList;
        String nativeDescription;
        String string = nativeDescription = p4number == -1L ? ChangesUtil.getDefaultChangeListName() : changeListDescription;
        if (nativeDescription == null) {
            LOG.info("Native changelist description getting problem, list number = " + p4number);
            nativeDescription = "";
        }
        LocalChangeList localChangeList = changeList = (name = this.mySynchronizer.getName(this.myConnectionKey, p4number)) == null ? null : addGate.findChangeList(name);
        if (name == null || changeList == null) {
            PerforceNameCommentConvertor convertor = PerforceNameCommentConvertor.fromNative(nativeDescription);
            changeList = addGate.findOrCreateList(convertor.getIdeaName(), convertor.getIdeaComment());
        }
        return changeList;
    }
}

