/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.VcsCheckinHandlerFactory;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.util.containers.MultiMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.actions.BrowseShelfAction;
import org.jetbrains.idea.perforce.actions.RevertAllUnchangedFilesAction;
import org.jetbrains.idea.perforce.application.PerforceCheckinOptionsPanel;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.ShelvedChange;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class PerforceCheckinHandlerFactory
extends VcsCheckinHandlerFactory {
    public PerforceCheckinHandlerFactory() {
        super(PerforceVcs.getKey());
    }

    @NotNull
    protected CheckinHandler createVcsHandler(final CheckinProjectPanel panel) {
        CheckinHandler checkinHandler = new CheckinHandler(){

            @Nullable
            public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
                return new PerforceCheckinOptionsPanel(panel.getProject());
            }

            public CheckinHandler.ReturnResult beforeCheckin() {
                Project project = panel.getProject();
                if (PerforceSettings.getSettings((Project)project).REVERT_UNCHANGED_FILES_CHECKIN) {
                    RevertAllUnchangedFilesAction.revertUnchanged(project, panel.getVirtualFiles(), panel, null);
                }
                MultiMap map = MultiMap.create();
                for (Change change : panel.getSelectedChanges()) {
                    LocalChangeList list = ChangeListManager.getInstance((Project)project).getChangeList(change);
                    if (list == null) continue;
                    map.putValue((Object)list, (Object)change);
                }
                for (LocalChangeList list : map.keySet()) {
                    List<ShelvedChange> shelvedChanges = PerforceManager.getInstance(project).getShelf().getShelvedChanges(list);
                    if (shelvedChanges.isEmpty()) continue;
                    String message = "The changelist \"" + list.getName() + "\" has shelved changes in Perforce.";
                    int rc = Messages.showYesNoDialog((Project)project, (String)message, (String)"Shelved Changes Found", (String)"&Remove Shelved Changes", (String)"Cancel", (Icon)Messages.getQuestionIcon());
                    if (rc == 1) {
                        return CheckinHandler.ReturnResult.CANCEL;
                    }
                    BrowseShelfAction.deleteFromShelf(BrowseShelfAction.groupByChangeList(shelvedChanges), project);
                }
                return super.beforeCheckin();
            }
        };
        if (checkinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory", "createVcsHandler"));
        }
        return checkinHandler;
    }

    public BeforeCheckinDialogHandler createSystemReadyHandler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory", "createSystemReadyHandler"));
        }
        return new MyBeforeCheckinDialogHandler();
    }

    public static boolean beforeRemoteOperationCheck(Project project, String operationName) {
        int result;
        PerforceSettings settings = PerforceSettings.getSettings(project);
        if (!settings.ENABLED && 0 == (result = Messages.showYesNoDialog((Project)project, (String)("Perforce is offline. " + operationName + " is not possible in this state.\nGo online?"), (String)"Perforce Is Offline", (Icon)Messages.getWarningIcon()))) {
            settings.enable();
        }
        boolean allOk = PerforceLoginManager.getInstance(project).checkAndRepairAll();
        return ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss().length > 1 || allOk && settings.ENABLED;
    }

    private static class MyBeforeCheckinDialogHandler
    extends BeforeCheckinDialogHandler {
        private MyBeforeCheckinDialogHandler() {
        }

        public boolean beforeCommitDialogShown(@NotNull Project project, @NotNull List<Change> changes, @NotNull Iterable<CommitExecutor> executors, boolean showVcsCommit) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory$MyBeforeCheckinDialogHandler", "beforeCommitDialogShown"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory$MyBeforeCheckinDialogHandler", "beforeCommitDialogShown"));
            }
            if (executors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executors", "org/jetbrains/idea/perforce/application/PerforceCheckinHandlerFactory$MyBeforeCheckinDialogHandler", "beforeCommitDialogShown"));
            }
            if (showVcsCommit) {
                return PerforceCheckinHandlerFactory.beforeRemoteOperationCheck(project, "Commit");
            }
            for (CommitExecutor executor : executors) {
                if (executor instanceof LocalCommitExecutor) continue;
                return PerforceCheckinHandlerFactory.beforeRemoteOperationCheck(project, "Commit");
            }
            return true;
        }
    }
}

