/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.PerforceInfoAndClient;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceServerUnavailable;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceClientRootsChecker
implements P4RootsInformation {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceClientRootsChecker");
    private final Map<P4Connection, WrongRoots> myMap = new HashMap<P4Connection, WrongRoots>();
    private final MultiMap<P4Connection, VcsException> myErrors = new MultiMap();
    private final Set<P4Connection> myNotAuthorized = new HashSet<P4Connection>();
    private final PerforceInfoAndClient myInfoAndClient;

    public PerforceClientRootsChecker() {
        this.myInfoAndClient = PerforceInfoAndClient.EMPTY_INFO;
    }

    public PerforceClientRootsChecker(PerforceInfoAndClient infoAndClient, Map<VirtualFile, P4Connection> map) {
        this.myInfoAndClient = infoAndClient;
        this.recalculate(map);
    }

    private void recalculate(Map<VirtualFile, P4Connection> map) {
        if (map.containsKey(null)) {
            LOG.info("Null root: " + new LinkedHashMap<VirtualFile, P4Connection>(map));
        }
        MultiMap<P4Connection, VirtualFile> inverse = PerforceClientRootsChecker.invertConnectionMap(map);
        for (P4Connection connection : inverse.keySet()) {
            List<String> clientRoots;
            Collection roots = inverse.get((Object)connection);
            try {
                clientRoots = this.getClientRoots(connection);
            }
            catch (PerforceAuthenticationException e) {
                this.myNotAuthorized.add(connection);
                continue;
            }
            catch (VcsException e) {
                this.myErrors.putValue((Object)connection, (Object)e);
                continue;
            }
            ContainerUtil.putIfNotNull((Object)connection, (Object)PerforceClientRootsChecker.checkRoots(roots, clientRoots), this.myMap);
        }
    }

    @Nullable
    private static WrongRoots checkRoots(Collection<VirtualFile> roots, List<String> clientRoots) {
        WrongRoots wrongRoots = null;
        for (VirtualFile root : roots) {
            if (root == null) continue;
            boolean checkedOk = false;
            File ioFile = new File(root.getPath());
            for (String clientRoot : clientRoots) {
                if ("null".equals(clientRoot)) {
                    checkedOk = true;
                    break;
                }
                File ioRoot = new File(clientRoot);
                if (!PerforceClientRootsChecker.isDirectory(ioRoot) || !FileUtil.isAncestor((File)ioRoot, (File)ioFile, (boolean)false)) continue;
                checkedOk = true;
                break;
            }
            if (checkedOk) continue;
            if (wrongRoots == null) {
                wrongRoots = new WrongRoots(clientRoots);
            }
            wrongRoots.addWrong(root);
        }
        return wrongRoots;
    }

    private static MultiMap<P4Connection, VirtualFile> invertConnectionMap(Map<VirtualFile, P4Connection> map) {
        MultiMap inverse = new MultiMap();
        for (Map.Entry<VirtualFile, P4Connection> entry : map.entrySet()) {
            inverse.putValue((Object)entry.getValue(), (Object)entry.getKey());
        }
        return inverse;
    }

    public boolean isServerUnavailable() {
        return ContainerUtil.findInstance(new ArrayList(this.myErrors.values()), PerforceServerUnavailable.class) != null;
    }

    public static boolean isDirectory(File file) {
        String path;
        if (file.isDirectory()) {
            return true;
        }
        return SystemInfo.isWindows && (path = file.getPath()).length() == 2 && Character.isLetter(path.charAt(0)) && ':' == path.charAt(1);
    }

    public PerforceInfoAndClient getInfoAndClient() {
        return this.myInfoAndClient;
    }

    private List<String> getClientRoots(P4Connection connection) throws VcsException {
        Map<String, List<String>> clientSpec = this.myInfoAndClient.getClient(connection);
        if (clientSpec == null) {
            throw new VcsException("No client specifications loaded");
        }
        ArrayList<String> result = new ArrayList<String>();
        List<String> mainRootValues = clientSpec.get("Root:");
        List<String> altRootValues = clientSpec.get("AltRoots:");
        if (mainRootValues != null) {
            result.addAll(mainRootValues);
        }
        if (altRootValues != null) {
            result.addAll(altRootValues);
        }
        return result;
    }

    @Override
    public MultiMap<P4Connection, VcsException> getErrors() {
        return this.myErrors;
    }

    @Override
    public boolean hasAnyErrors() {
        return !this.myMap.isEmpty() || !this.myErrors.isEmpty();
    }

    @Override
    public boolean hasNotAuthorized() {
        return !this.myNotAuthorized.isEmpty();
    }

    @Override
    public Set<P4Connection> getNotAuthorized() {
        return this.myNotAuthorized;
    }

    @Override
    public Map<P4Connection, WrongRoots> getMap() {
        return this.myMap;
    }

    public static class WrongRoots {
        private final List<String> myActualInClientSpec;
        private final List<VirtualFile> myWrong;

        public WrongRoots(List<String> actualInClientSpec) {
            this.myActualInClientSpec = actualInClientSpec;
            this.myWrong = new ArrayList<VirtualFile>();
        }

        public void addWrong(VirtualFile file) {
            this.myWrong.add(file);
        }

        public List<String> getActualInClientSpec() {
            return this.myActualInClientSpec;
        }

        public List<VirtualFile> getWrong() {
            return this.myWrong;
        }
    }
}

