/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffMixin;
import com.intellij.openapi.vcs.diff.DiffProviderEx;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.perforce.application.PerforceBinaryContentRevision;
import org.jetbrains.idea.perforce.application.PerforceCommittedChangesProvider;
import org.jetbrains.idea.perforce.application.PerforceOnlyRevisionNumber;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;

public class PerforceDiffProvider
extends DiffProviderEx
implements DiffMixin {
    private final Project myProject;
    @NonNls
    private static final String REVISION_NONE = "none";

    public PerforceDiffProvider(Project project) {
        this.myProject = project;
    }

    public Map<VirtualFile, VcsRevisionNumber> getCurrentRevisions(Iterable<VirtualFile> files) {
        LinkedHashMap p4Files = ContainerUtil.newLinkedHashMap();
        for (VirtualFile file : files) {
            p4Files.put(file, P4File.create(this.getOriginalIfMoved(file)));
        }
        try {
            LinkedHashMap result = ContainerUtil.newLinkedHashMap();
            Map<P4File, FStat> fStatMap = PerforceRunner.getInstance(this.myProject).fstatBulk(ContainerUtil.newArrayList(p4Files.values()));
            for (VirtualFile file : files) {
                FStat fStat = fStatMap.get(p4Files.get(file));
                result.put(file, PerforceVcsRevisionNumber.createFromFStat(fStat));
            }
            return result;
        }
        catch (VcsException e) {
            return Collections.emptyMap();
        }
    }

    public VcsRevisionNumber getCurrentRevision(VirtualFile file) {
        FilePath path = this.getOriginalIfMoved(file);
        return PerforceRunner.getInstance(this.myProject).getCurrentRevision(P4File.create(path));
    }

    private FilePath getOriginalIfMoved(VirtualFile file) {
        return ChangesUtil.getCommittedPath((Project)this.myProject, (FilePath)VcsUtil.getFilePath((VirtualFile)file));
    }

    public VcsRevisionDescription getCurrentRevisionDescription(VirtualFile file) {
        try {
            VcsRevisionNumber number = this.getCurrentRevision(file);
            if (number == null) {
                return null;
            }
            PerforceCommittedChangesProvider provider = PerforceVcs.getInstance(this.myProject).getCommittedChangesProvider();
            Pair<PerforceChangeList, FilePath> oneList = provider.getOneList(file, number);
            if (oneList != null) {
                return new VcsRevisionDescriptionImpl(number, ((PerforceChangeList)oneList.getFirst()).getCommitDate(), ((PerforceChangeList)oneList.getFirst()).getCommitterName(), ((PerforceChangeList)oneList.getFirst()).getComment());
            }
        }
        catch (VcsException e) {
            return null;
        }
        return null;
    }

    private static boolean isInvalidRevision(String revision) {
        return revision == null || revision.length() == 0 || revision.equals(REVISION_NONE);
    }

    public ItemLatestState getLastRevision(VirtualFile file) {
        try {
            FStat fstat = P4File.create(this.getOriginalIfMoved(file)).getFstat(this.myProject, false);
            String headRev = fstat.headRev;
            if (PerforceDiffProvider.isInvalidRevision(headRev)) {
                return null;
            }
            return new ItemLatestState((VcsRevisionNumber)new VcsRevisionNumber.Long(Long.parseLong(headRev)), true, false);
        }
        catch (VcsException e) {
            return null;
        }
    }

    public ContentRevision createFileContent(VcsRevisionNumber revisionNumber, VirtualFile selectedFile) {
        long revNumber = revisionNumber instanceof PerforceVcsRevisionNumber ? ((PerforceVcsRevisionNumber)revisionNumber).getRevisionNumber() : (revisionNumber instanceof PerforceOnlyRevisionNumber ? ((PerforceOnlyRevisionNumber)revisionNumber).getNumber() : ((VcsRevisionNumber.Long)revisionNumber).getLongValue());
        FilePath filePath = this.getOriginalIfMoved(selectedFile);
        if (selectedFile.getFileType().isBinary()) {
            return new PerforceBinaryContentRevision(this.myProject, filePath, revNumber);
        }
        return new PerforceContentRevision(this.myProject, filePath, revNumber);
    }

    public ItemLatestState getLastRevision(FilePath filePath) {
        try {
            FStat fstat = P4File.create(ChangesUtil.getCommittedPath((Project)this.myProject, (FilePath)filePath)).getFstat(this.myProject, false);
            String headRev = fstat.headRev;
            if (PerforceDiffProvider.isInvalidRevision(headRev)) {
                return null;
            }
            return new ItemLatestState((VcsRevisionNumber)new VcsRevisionNumber.Long(Long.parseLong(headRev)), true, false);
        }
        catch (VcsException e) {
            return null;
        }
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }
}

