/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceUnversionedTracker;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.UnversionedScopeScanner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public class PerforceReadOnlyFileStateManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.PerforceReadOnlyFileStateManager");
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final MyVfsListener myVfsListener = new MyVfsListener();
    private final PerforceUnversionedTracker myUnversionedTracker;
    private final Object myLock = new Object();
    private final FrameStateListener myFrameStateListener = new FrameStateListener.Adapter(){

        public void onFrameDeactivated() {
            PerforceReadOnlyFileStateManager.this.processFocusLost();
        }
    };
    private final Set<VirtualFile> myPreviousAddedSnapshot = new HashSet<VirtualFile>();
    private MessageBusConnection myConnection;
    private volatile boolean myPreviousRescanProblem;
    private volatile boolean myHasLostFocus;

    public PerforceReadOnlyFileStateManager(Project project) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myUnversionedTracker = new PerforceUnversionedTracker(project);
    }

    PerforceUnversionedTracker getUnversionedTracker() {
        return this.myUnversionedTracker;
    }

    public void activate() {
        final Runnable scheduleTotalRescan = new Runnable(){

            @Override
            public void run() {
                ((PerforceReadOnlyFileStateManager)PerforceReadOnlyFileStateManager.this).myUnversionedTracker.isActive = false;
                PerforceReadOnlyFileStateManager.this.myUnversionedTracker.totalRescan();
            }
        };
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(){

            public void directoryMappingChanged() {
                scheduleTotalRescan.run();
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myVfsListener);
        FrameStateManager.getInstance().addListener(this.myFrameStateListener);
        this.myConnection.subscribe(PerforceSettings.OFFLINE_MODE_EXITED, (Object)scheduleTotalRescan);
    }

    public void deactivate() {
        this.myUnversionedTracker.isActive = false;
        this.myConnection.disconnect();
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myVfsListener);
        FrameStateManager.getInstance().removeListener(this.myFrameStateListener);
        this.myHasLostFocus = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getChanges(VcsDirtyScope dirtyScope, final ChangelistBuilder builder, final ProgressIndicator progress, final ChangeListManagerGate addGate) throws VcsException {
        ThrowableComputable<UnversionedScopeScanner.ScanResult, VcsException> scanner;
        Set<VirtualFile> newAdded = this.getAddedFilesInCurrentChangesView(addGate);
        Object object = this.myLock;
        synchronized (object) {
            progress.checkCanceled();
            this.recheckPreviouslyAddedFiles(newAdded);
            this.recheckWhatUnversionedRefreshNeeded(dirtyScope);
            scanner = this.myUnversionedTracker.createScanner();
        }
        progress.checkCanceled();
        UnversionedScopeScanner.ScanResult result = this.rescan(scanner);
        progress.checkCanceled();
        for (VirtualFile file : result.allLocalFiles) {
            this.myUnversionedTracker.markUnknown(file);
        }
        this.myUnversionedTracker.markUnversioned(result.localOnly);
        dirtyScope.iterateExistingInsideScope((Processor)new Processor<VirtualFile>(){

            public boolean process(VirtualFile vf) {
                progress.checkCanceled();
                FileStatus status = addGate.getStatus(vf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("status " + status + " for " + vf);
                }
                if (status == null) {
                    if (PerforceReadOnlyFileStateManager.this.myUnversionedTracker.isUnversioned(vf)) {
                        builder.processUnversionedFile(vf);
                    } else if (PerforceReadOnlyFileStateManager.this.myUnversionedTracker.isIgnored(vf)) {
                        builder.processIgnoredFile(vf);
                    }
                }
                return true;
            }
        });
        Set<String> locallyDeleted = PerforceReadOnlyFileStateManager.findLocallyDeletedMissingFiles(addGate, result.missingFiles);
        for (String path : locallyDeleted) {
            builder.processLocallyDeletedFile(VcsUtil.getFilePath((String)path, (boolean)false));
        }
    }

    private UnversionedScopeScanner.ScanResult rescan(ThrowableComputable<UnversionedScopeScanner.ScanResult, VcsException> scanner) throws VcsException {
        this.myUnversionedTracker.isActive = true;
        this.myPreviousRescanProblem = false;
        try {
            return (UnversionedScopeScanner.ScanResult)scanner.compute();
        }
        catch (VcsException e) {
            this.myPreviousRescanProblem = true;
            throw e;
        }
    }

    private Set<VirtualFile> getAddedFilesInCurrentChangesView(ChangeListManagerGate addGate) {
        HashSet<VirtualFile> set = new HashSet<VirtualFile>();
        for (LocalChangeList list : addGate.getListsCopy()) {
            for (Change change : list.getChanges()) {
                VirtualFile file;
                ContentRevision afterRevision = change.getAfterRevision();
                if (!FileStatus.ADDED.equals(change.getFileStatus()) || afterRevision == null || (file = afterRevision.getFile().getVirtualFile()) == null || !this.fileIsUnderP4Root(file)) continue;
                set.add(file);
            }
        }
        return set;
    }

    private void recheckWhatUnversionedRefreshNeeded(VcsDirtyScope dirtyScope) {
        if (this.myHasLostFocus && dirtyScope.wasEveryThingDirty()) {
            LOG.info("--- recheck missing");
            this.myHasLostFocus = false;
            if (this.myPreviousRescanProblem) {
                this.myUnversionedTracker.totalRescan();
            }
        }
    }

    private void recheckPreviouslyAddedFiles(Set<VirtualFile> newAdded) {
        HashSet<VirtualFile> copy = new HashSet<VirtualFile>(this.myPreviousAddedSnapshot);
        copy.removeAll(newAdded);
        this.myPreviousAddedSnapshot.clear();
        this.myPreviousAddedSnapshot.addAll(newAdded);
        if (!copy.isEmpty()) {
            this.myUnversionedTracker.reportRecheck(copy);
        }
    }

    private static Set<String> findLocallyDeletedMissingFiles(ChangeListManagerGate addGate, Set<String> missingFiles) {
        HashSet locallyDeleted = ContainerUtil.newHashSet();
        for (String path : missingFiles) {
            if (FileStatus.DELETED.equals(addGate.getStatus(new File(path)))) continue;
            locallyDeleted.add(path);
        }
        return locallyDeleted;
    }

    public void processFocusLost() {
        this.myHasLostFocus = true;
    }

    public void discardUnversioned() {
        this.myUnversionedTracker.totalRescan();
    }

    private boolean fileIsUnderP4Root(VirtualFile file) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (ChangeListManager.getInstance((Project)this.myProject).isIgnoredFile(file)) {
            return false;
        }
        AbstractVcs vcs = this.myVcsManager.getVcsFor(file);
        return vcs != null && PerforceVcs.getKey().equals((Object)vcs.getKeyInstanceMethod());
    }

    private class MyVfsListener
    extends VirtualFileAdapter {
        private MyVfsListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$MyVfsListener", "propertyChanged"));
            }
            VirtualFile file = event.getFile();
            if (PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(file) && "writable".equals(event.getPropertyName())) {
                PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportRecheck(file);
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$MyVfsListener", "contentsChanged"));
            }
            VirtualFile file = event.getFile();
            if (PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(file) && !file.isWritable()) {
                PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportRecheck(file);
            }
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$MyVfsListener", "fileCreated"));
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            this.processCreated(event.getFile());
        }

        private void processCreated(VirtualFile root) {
            PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportRecheck(root);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$MyVfsListener", "fileMoved"));
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            this.processCreated(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$MyVfsListener", "fileCopied"));
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            this.processCreated(event.getFile());
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$MyVfsListener", "beforeFileDeletion"));
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportDelete(event.getFile());
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$MyVfsListener", "beforeFileMovement"));
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportDelete(event.getFile());
        }
    }
}

