/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.history.LongRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4Revision;

public class PerforceVcsRevisionNumber
implements VcsRevisionNumber,
LongRevisionNumber {
    private final long myRevisionNumber;
    private final long myChangeNumber;
    private final boolean myBranched;
    private final String myDepotPath;

    /*
     * WARNING - void declaration
     */
    public PerforceVcsRevisionNumber(long revisionNumber, long changeNumber, boolean bl, @NotNull String string) {
        void depotPath;
        void branched;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depotPath", "org/jetbrains/idea/perforce/application/PerforceVcsRevisionNumber", "<init>"));
        }
        this.myRevisionNumber = revisionNumber;
        this.myChangeNumber = changeNumber;
        this.myBranched = branched;
        this.myDepotPath = depotPath;
    }

    public PerforceVcsRevisionNumber(P4Revision p4Revision) {
        this(p4Revision.getRevisionNumber(), p4Revision.getChangeNumber(), p4Revision.isBranched(), p4Revision.getDepotPath());
    }

    @Nullable
    public static PerforceVcsRevisionNumber createFromFStat(FStat fstat) {
        try {
            return new PerforceVcsRevisionNumber(Long.parseLong(fstat.haveRev), Long.parseLong(fstat.headChange), false, fstat.depotFile);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String asString() {
        return String.valueOf(this.myChangeNumber);
    }

    public long getLongRevisionNumber() {
        return this.myChangeNumber;
    }

    public int compareTo(VcsRevisionNumber o) {
        if (o instanceof PerforceVcsRevisionNumber) {
            return Long.signum(this.myChangeNumber - ((PerforceVcsRevisionNumber)o).myChangeNumber);
        }
        if (o instanceof VcsRevisionNumber.Long) {
            return Long.signum(this.myRevisionNumber - ((VcsRevisionNumber.Long)o).getLongValue());
        }
        return 0;
    }

    @NotNull
    public String getDepotPath() {
        String string = this.myDepotPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/PerforceVcsRevisionNumber", "getDepotPath"));
        }
        return string;
    }

    public long getRevisionNumber() {
        return this.myRevisionNumber;
    }

    public long getChangeNumber() {
        return this.myChangeNumber;
    }

    public boolean isBranched() {
        return this.myBranched;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerforceVcsRevisionNumber that = (PerforceVcsRevisionNumber)o;
        if (this.myChangeNumber != that.myChangeNumber) {
            return false;
        }
        return this.myRevisionNumber == that.myRevisionNumber && Comparing.equal((String)this.myDepotPath, (String)that.myDepotPath);
    }

    public int hashCode() {
        int result = (int)(this.myRevisionNumber ^ this.myRevisionNumber >>> 32);
        result = 29 * result + (int)(this.myChangeNumber ^ this.myChangeNumber >>> 32);
        if (this.myDepotPath != null) {
            result = 29 * result + this.myDepotPath.hashCode();
        }
        return result;
    }

    public String toString() {
        return Long.toString(this.myChangeNumber);
    }
}

