/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.perforce.PerforceAbstractChange;
import org.jetbrains.idea.perforce.perforce.PerforceContentRevision;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class ShelvedChange
extends PerforceAbstractChange {
    private final String myDepotPath;
    private final long myRevision;
    private final long myChangeList;
    private final P4Connection myConnection;

    /*
     * WARNING - void declaration
     */
    public ShelvedChange(int type, @NotNull String depotPath, long revision, @NotNull P4Connection connection, @Nullable File localFile, long l) {
        void changeList;
        if (depotPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depotPath", "org/jetbrains/idea/perforce/application/ShelvedChange", "<init>"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/ShelvedChange", "<init>"));
        }
        this.myDepotPath = depotPath;
        this.myRevision = revision;
        this.myConnection = connection;
        this.myChangeList = changeList;
        this.myType = type;
        this.setFile(localFile);
    }

    @NotNull
    public String getDepotPath() {
        String string = this.myDepotPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/application/ShelvedChange", "getDepotPath"));
        }
        return string;
    }

    public String toString() {
        return "ShelvedChange{myRevision=" + this.myRevision + ", myDepotPath='" + this.myDepotPath + '\'' + '}';
    }

    public Change toIdeaChange(Project project) {
        PerforceContentRevision beforeRevision = this.myType == 0 || this.myType == 5 ? null : PerforceContentRevision.create(project, this.myConnection, this.myDepotPath, this.myRevision, -1L);
        PerforceContentRevision afterRevision = this.myType == 1 || this.myType == 6 ? null : PerforceContentRevision.create(project, this.myConnection, this.myDepotPath, -1L, this.myChangeList);
        return new IdeaChange(beforeRevision, afterRevision, this);
    }

    public long getChangeList() {
        return this.myChangeList;
    }

    public P4Connection getConnection() {
        return this.myConnection;
    }

    public static class IdeaChange
    extends Change {
        private final ShelvedChange myOriginal;

        public IdeaChange(@Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision, ShelvedChange original) {
            super(beforeRevision, afterRevision);
            this.myOriginal = original;
        }

        public ShelvedChange getOriginal() {
            return this.myOriginal;
        }
    }
}

