/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application.annotation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.VcsException;
import gnu.trove.TIntArrayList;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;

public class AnnotationInfo {
    private final String myContent;
    private final int[] myRevisions;
    private final boolean myUseChangelistNumbers;
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.application.annotation.AnnotationInfo");

    public AnnotationInfo(String output, boolean useChangelistNumbers) throws IOException, VcsException {
        this.myUseChangelistNumbers = useChangelistNumbers;
        LineNumberReader reader = new LineNumberReader(new StringReader(output));
        StringBuffer content = new StringBuffer();
        TIntArrayList revisions = new TIntArrayList();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int endOfRevisionIndex = line.indexOf(":");
                if (endOfRevisionIndex <= 0) continue;
                String revision = line.substring(0, endOfRevisionIndex);
                String contentLine = line.substring(endOfRevisionIndex + 2);
                content.append(contentLine);
                content.append("\n");
                revisions.add(Integer.parseInt(revision));
            }
        }
        catch (NumberFormatException e) {
            LOG.info("Can not parse annotation output: \n'" + output + "'", (Throwable)e);
            throw new VcsException("Can not parse annotation output", (Throwable)e);
        }
        this.myContent = content.toString();
        this.myRevisions = revisions.toNativeArray();
    }

    public String getContent() {
        return this.myContent;
    }

    public int getRevision(int lineNumber) {
        if (lineNumber < 0 || lineNumber >= this.myRevisions.length) {
            return -1;
        }
        return this.myRevisions[lineNumber];
    }

    public boolean isUseChangelistNumbers() {
        return this.myUseChangelistNumbers;
    }

    public int getLineCount() {
        return this.myRevisions.length;
    }
}

