/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.process.InterruptibleProcess;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.MemoryDumpHelper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.StreamGobbler;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.ExecResult;
import org.jetbrains.idea.perforce.perforce.P4Command;
import org.jetbrains.idea.perforce.perforce.PerforcePhysicalConnectionParametersI;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.PerforceTimeoutException;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigFields;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceProcessWaiter;

public abstract class AbstractP4Connection
implements P4Connection {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.perforce.connections.AbstractP4Connection");
    public static final int TIMEOUT_EXIT_CODE = -2;
    public static final String CONNECT_REFUSED = "Connect to server failed";
    private volatile boolean myNotConnected = false;
    private static Map<String, String> ourTestEnvironment = Collections.emptyMap();
    private static Consumer<String> ourCommandCallback = Consumer.EMPTY_CONSUMER;

    @Override
    public ExecResult runP4CommandLine(PerforceSettings settings, String[] strings, StringBuffer stringBuffer) throws VcsException {
        ExecResult result = new ExecResult();
        try {
            this.runP4Command(settings, strings, result, stringBuffer);
        }
        catch (PerforceTimeoutException e) {
            throw new VcsException((Throwable)e);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new VcsException((Throwable)e);
        }
        return result;
    }

    @Override
    public String getWorkingDir() {
        return this.getId().myWorkingDir;
    }

    protected void runP4CommandImpl(PerforcePhysicalConnectionParametersI parameters, String[] connArgs, String[] p4args, ExecResult retVal, StringBuffer inputStream, File cwd) throws VcsException, PerforceTimeoutException, IOException, InterruptedException {
        try {
            this.runCmdLine(parameters, connArgs, p4args, retVal, inputStream, cwd);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            String message;
            if (e instanceof ProcessNotCreatedException && (message = e.getMessage()) != null && message.contains("No such file or directory")) {
                retVal.setException((Throwable)new ProcessNotCreatedException("Invalid Perforce executable name\n" + e.getMessage(), e.getCause(), ((ProcessNotCreatedException)e).getCommandLine()));
                return;
            }
            retVal.setException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCmdLine(PerforcePhysicalConnectionParametersI perforceSettings, String[] connArgs, @NonNls String[] p4args, ExecResult retVal, StringBuffer inputData, File cwd) throws Exception {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            // empty if block
        }
        GeneralCommandLine cmd = AbstractP4Connection.fillCmdLine(perforceSettings, connArgs, p4args);
        cmd.setWorkDirectory(cwd);
        AbstractP4Connection.setEnvironment(cwd, cmd.getEnvironment());
        CommandDebugInfoWrapper debugInfoWrapper = new CommandDebugInfoWrapper(cmd);
        Tracer tracer = new Tracer(perforceSettings.getProject(), p4args.length > 0 ? p4args[0] : "", debugInfoWrapper);
        this.debugCmd(cwd, debugInfoWrapper, EnvironmentUtil.flattenEnvironment((Map)cmd.getEnvironment()));
        int rc = -42;
        Process proc = null;
        MyInterruptibleProcess worker = null;
        PerforceProcessWaiter processWaiter = null;
        String processList = null;
        try {
            tracer.start();
            proc = cmd.createProcess();
            if (inputData != null) {
                AbstractP4Connection.passInputToProcess(inputData.toString(), proc, perforceSettings);
            }
            worker = new MyInterruptibleProcess(perforceSettings.getProject(), proc, perforceSettings.getServerTimeout());
            final PerforceProcessWaiter processWaiterCopy = processWaiter = new PerforceProcessWaiter();
            worker.setOnBeforeInterrupt(new Runnable(){

                @Override
                public void run() {
                    processWaiterCopy.cancelListeners();
                }
            });
            rc = processWaiter.execute(worker, perforceSettings.getServerTimeout());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            rc = -2;
        }
        finally {
            if (rc == -2 && ApplicationManager.getApplication().isUnitTestMode()) {
                processList = LogUtil.getProcessList();
            }
            tracer.stop();
            if (worker != null) {
                worker.closeProcess();
            } else if (proc != null) {
                InterruptibleProcess.close((Process)proc);
            }
        }
        if (rc == 0) {
            retVal.setExitCode(worker.getExitCode());
            retVal.setOutputGobbler((StreamGobbler)processWaiter.getInStreamListener());
            retVal.setErrorGobbler((StreamGobbler)processWaiter.getErrStreamListener());
            if (worker.getExitCode() != 0 && retVal.getException() == null && retVal.getStderr().contains(CONNECT_REFUSED)) {
                this.notConnected();
                return;
            }
        } else {
            if (rc == -2) {
                retVal.setOutputGobbler((StreamGobbler)processWaiter.getInStreamListener());
                retVal.setErrorGobbler((StreamGobbler)processWaiter.getErrStreamListener());
                LOG.info("Perforce real timeout: " + perforceSettings.getServerTimeout());
                LOG.info("stdout: " + retVal.getStdout());
                LOG.info("stderr: " + retVal.getStderr());
                retVal.setStdout("");
                retVal.setStderr(PerforceBundle.message((String)"exception.text.perforce.integration.disconnected", (Object[])new Object[0]));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("process list: " + processList);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    System.out.println("======================");
                    System.out.println("system info: " + LogUtil.getSystemMemoryInfo());
                    String dumpPath = FileUtil.createTempFile((File)new File(System.getProperty("teamcity.build.tempDir", System.getProperty("java.io.tmpdir"))), (String)"perforce", (String)".hprof", (boolean)false, (boolean)false).getPath();
                    MemoryDumpHelper.captureMemoryDump((String)dumpPath);
                    System.out.println("Captured " + dumpPath);
                }
                processWaiter.clearGobblers();
                throw new PerforceTimeoutException();
            }
            LOG.info("Perforce unreal timeout: " + perforceSettings.getServerTimeout() + "; rc=" + rc);
            this.notConnected();
            perforceSettings.disable();
            processWaiter.clearGobblers();
            throw new PerforceTimeoutException();
        }
        this.connected();
    }

    public static void setTestEnvironment(Map<String, String> env, Disposable parentDisposable) {
        if (!ourTestEnvironment.isEmpty()) {
            ourTestEnvironment.putAll(env);
            return;
        }
        ourTestEnvironment = env;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourTestEnvironment = Collections.emptyMap();
            }
        });
    }

    public static Map<String, String> getTestEnvironment() {
        return ourTestEnvironment;
    }

    public static void setCommandCallback(Consumer<String> callback, Disposable parentDisposable) {
        assert (ourCommandCallback == Consumer.EMPTY_CONSUMER);
        ourCommandCallback = callback;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ourCommandCallback = Consumer.EMPTY_CONSUMER;
            }
        });
    }

    private static GeneralCommandLine fillCmdLine(PerforcePhysicalConnectionParametersI perforceSettings, String[] connArgs, String[] p4args) {
        boolean addZProg;
        String cmdName;
        GeneralCommandLine cmd = new GeneralCommandLine(new String[]{perforceSettings.getPathToExec()});
        String string = cmdName = p4args.length == 0 ? null : p4args[0];
        if (ourCommandCallback != Consumer.EMPTY_CONSUMER) {
            ourCommandCallback.consume((Object)StringUtil.join((String[])p4args, (String)" "));
        }
        if (addZProg = "true".equals(System.getProperty("perforce.specify.zprog", "true"))) {
            cmd.addParameter("-zprog=IntelliJ_IDEA_" + cmdName);
        }
        cmd.addParameters(connArgs);
        cmd.addParameters(p4args);
        return cmd;
    }

    private static void setEnvironment(File cwd, Map<String, String> env) {
        env.put("PWD", cwd.getAbsolutePath());
        env.putAll(ourTestEnvironment);
    }

    private static void passInputToProcess(String inputData, Process proc, PerforcePhysicalConnectionParametersI perforceSettings) throws IOException {
        byte[] bytes;
        OutputStream outputStream = proc.getOutputStream();
        String charsetName = perforceSettings.getCharsetName();
        try {
            bytes = !PerforceSettings.CHARSET_NONE.equals(charsetName) ? inputData.getBytes(charsetName) : inputData.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            LOG.info((Throwable)e);
            bytes = inputData.getBytes();
        }
        outputStream.write(bytes);
        outputStream.close();
    }

    private void debugCmd(File cwd, CommandDebugInfoWrapper wrapper, String[] env) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("[Perf Execute:] " + wrapper.getPresentation() + "\n [cwd] " + cwd + "\n env=" + Arrays.toString(env) + "\n connection=" + this);
        }
    }

    public void notConnected() {
        this.myNotConnected = true;
    }

    public void connected() {
        this.myNotConnected = false;
    }

    @Override
    public boolean isConnected() {
        return !this.myNotConnected;
    }

    private static class Tracer {
        private final PerforceManager myPm;
        @NotNull
        private final P4Command myCommand;
        private final CommandDebugInfoWrapper myWrapper;
        private Object myContext;

        Tracer(Project project, String commandName, CommandDebugInfoWrapper wrapper) {
            this.myPm = PerforceManager.getInstance(project);
            this.myCommand = P4Command.getInstance(commandName);
            this.myWrapper = wrapper;
        }

        void start() {
            if (this.myPm.isTraceEnabled()) {
                this.myContext = this.myPm.traceEnter(this.myCommand, this.myWrapper.getPresentation());
            }
        }

        void stop() {
            if (this.myPm.isTraceEnabled()) {
                if (this.myContext == null) {
                    LOG.info("Tracing problem: no enter was registered for " + this.myWrapper.getPresentation());
                    return;
                }
                this.myPm.traceExit(this.myContext, this.myCommand, this.myWrapper.getPresentation());
            }
        }
    }

    private static class MyInterruptibleProcess
    extends InterruptibleProcess {
        private final boolean myNeedStallDialog;
        private final Project myProject;
        private Runnable myOnBeforeInterrupt;

        private MyInterruptibleProcess(Project project, Process process, long timeout) {
            super(process, timeout, TimeUnit.MILLISECONDS);
            this.myProject = project;
            this.myNeedStallDialog = SwingUtilities.isEventDispatchThread() || ProgressManager.getInstance().hasModalProgressIndicator();
        }

        public void closeProcess() {
            if (this.myOnBeforeInterrupt != null) {
                this.myOnBeforeInterrupt.run();
            }
            super.closeProcess();
        }

        public void setOnBeforeInterrupt(Runnable onBeforeInterrupt) {
            this.myOnBeforeInterrupt = onBeforeInterrupt;
        }

        protected int processTimeout() {
            if (this.myProject.isDisposed()) {
                return -2;
            }
            return Messages.showOkCancelDialog((Project)this.myProject, (String)PerforceBundle.message((String)"confirmation.text.perforce.server.not.responding.disable.integration", (Object[])new Object[0]), (String)PerforceBundle.message((String)"dialog.title.perforce", (Object[])new Object[0]), (String)PerforceBundle.message((String)"button.text.wait.more", (Object[])new Object[0]), (String)PerforceBundle.message((String)"button.text.resent.and.disable.integration", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        }

        protected int processTimeoutInEDT() {
            if (!this.myNeedStallDialog || this.myProject.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
                return -2;
            }
            return super.processTimeoutInEDT();
        }
    }

    private static class CommandDebugInfoWrapper {
        private final GeneralCommandLine myCmd;
        private String myPresentation;

        private CommandDebugInfoWrapper(GeneralCommandLine cmd) {
            this.myCmd = cmd;
        }

        String getPresentation() {
            if (this.myPresentation == null) {
                StringBuilder presentation = new StringBuilder();
                String option = P4ConfigFields.P4PASSWD.getFlag();
                List args = this.myCmd.getParametersList().getList();
                for (int i = 0; i < args.size(); ++i) {
                    String s = (String)args.get(i);
                    presentation.append(" ").append(s);
                    if (!option.equals(s.trim()) || i + 1 >= args.size()) continue;
                    presentation.append(" *****");
                    ++i;
                }
                this.myPresentation = presentation.toString();
            }
            return this.myPresentation;
        }
    }
}

