/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jetbrains.idea.perforce.perforce.jobs.DefaultGb;
import org.jetbrains.idea.perforce.perforce.jobs.ErrorReporter;
import org.jetbrains.idea.perforce.perforce.jobs.JobDetailsLoader;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJobFieldValue;

class SelfLoadingJobDetailsPanel {
    private JPanel myMain;
    private final Project myProject;
    private final PerforceJob myJob;
    private final List<Pair<String, String>> myDetails;
    private final JPanel myPanel;

    SelfLoadingJobDetailsPanel(Project project, PerforceJob job) {
        this.myProject = project;
        this.myJob = job;
        this.myDetails = new ArrayList<Pair<String, String>>();
        this.myPanel = new JPanel(new BorderLayout());
        this.createDetailsPanel();
    }

    private void initData() {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (SelfLoadingJobDetailsPanel.this.load()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SelfLoadingJobDetailsPanel.this.myMain.removeAll();
                            GridBagConstraints gb = DefaultGb.create();
                            gb.anchor = 18;
                            for (Pair detail : SelfLoadingJobDetailsPanel.this.myDetails) {
                                JLabel label = new JLabel((String)detail.getFirst() + ":");
                                JTextArea text = new JTextArea(((String)detail.getSecond()).trim());
                                text.setEditable(false);
                                text.setBackground(UIUtil.getBgFillColor((Component)SelfLoadingJobDetailsPanel.this.myMain));
                                gb.gridx = 0;
                                gb.fill = 0;
                                gb.weightx = 0.0;
                                SelfLoadingJobDetailsPanel.this.myMain.add((Component)label, gb);
                                ++gb.gridx;
                                gb.fill = 2;
                                gb.weightx = 1.0;
                                SelfLoadingJobDetailsPanel.this.myMain.add((Component)text, gb);
                                ++gb.gridy;
                            }
                            SelfLoadingJobDetailsPanel.this.myPanel.revalidate();
                            SelfLoadingJobDetailsPanel.this.myPanel.repaint();
                        }
                    });
                }
            }
        });
    }

    private void createDetailsPanel() {
        this.myMain = new JPanel(new GridBagLayout());
        GridBagConstraints gb = DefaultGb.create();
        gb.anchor = 10;
        gb.fill = 1;
        gb.weighty = 1.0;
        gb.weightx = 1.0;
        this.myMain.add((Component)new JLabel("Loading..."), gb);
        this.myPanel.add((Component)this.myMain, "North");
        this.initData();
    }

    private boolean load() {
        try {
            List<Pair<String, String>> items = new JobDetailsLoader(this.myProject).load(this.myJob);
            if (items != null) {
                PerforceJobFieldValue nameValue = this.myJob.getNameValue();
                if (nameValue != null) {
                    String fieldName = nameValue.getField().getName();
                    String name = nameValue.getValue();
                    items.remove(Pair.create((Object)fieldName, (Object)name));
                }
                this.myDetails.addAll(items);
            }
        }
        catch (VcsException e) {
            new ErrorReporter("loading job details").report(this.myProject, e);
            return false;
        }
        return true;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }
}

