/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.compiler;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.compiler.MobileMakeUtil;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.MobileSdk;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ClassPostProcessingCompiler;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.EmptyValidityState;
import com.intellij.openapi.compiler.FileProcessingCompiler;
import com.intellij.openapi.compiler.ValidityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ActionRunner;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class J2MEPreverifier
implements ClassPostProcessingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    private final HashMap<Module, File> myModulePreverifiedClasses = new HashMap();

    @NotNull
    public FileProcessingCompiler.ProcessingItem[] getProcessingItems(final CompileContext context) {
        this.myModulePreverifiedClasses.clear();
        FileProcessingCompiler.ProcessingItem[] processingItemArray = (FileProcessingCompiler.ProcessingItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<FileProcessingCompiler.ProcessingItem[]>(){

            public FileProcessingCompiler.ProcessingItem[] compute() {
                Module[] affectedModules = context.getCompileScope().getAffectedModules();
                if (affectedModules == null || affectedModules.length == 0) {
                    return FileProcessingCompiler.ProcessingItem.EMPTY_ARRAY;
                }
                ArrayList<MyProcessingItem> result = new ArrayList<MyProcessingItem>();
                for (Module module : affectedModules) {
                    if (module.isDisposed() || !ModuleType.get((Module)module).equals((Object)J2MEModuleType.getInstance())) continue;
                    Sdk jdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (!MobileSdk.checkCorrectness(jdk, module)) {
                        context.addMessage(CompilerMessageCategory.ERROR, J2MEBundle.message("compiler.jdk.is.invalid.common", jdk != null ? jdk.getName() : " "), null, -1, -1);
                        continue;
                    }
                    if (((Emulator)jdk.getSdkAdditionalData()).getEmulatorType().getPreverifyPath(jdk.getHomePath()) == null) continue;
                    try {
                        File temp = FileUtil.createTempDirectory((String)"temp", (String)"temp");
                        temp.deleteOnExit();
                        J2MEPreverifier.this.myModulePreverifiedClasses.put(module, temp);
                        HashSet<Module> modulesToPreverify = new HashSet<Module>();
                        MobileMakeUtil.getDependencies(module, modulesToPreverify);
                        ArrayList<VirtualFile> dependantClasspath = new ArrayList<VirtualFile>();
                        for (Module toPreverify : modulesToPreverify) {
                            if (module.equals(toPreverify)) continue;
                            VirtualFile moduleOutputDirectory = context.getModuleOutputDirectory(toPreverify);
                            dependantClasspath.add(moduleOutputDirectory);
                            if (moduleOutputDirectory == null) continue;
                            result.add(new MyProcessingItem(moduleOutputDirectory, toPreverify, temp, jdk, null));
                        }
                        VirtualFile moduleOutputDirectory = context.getModuleOutputDirectory(module);
                        if (moduleOutputDirectory == null) continue;
                        result.add(new MyProcessingItem(moduleOutputDirectory, module, temp, jdk, dependantClasspath));
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                }
                return result.toArray(new FileProcessingCompiler.ProcessingItem[result.size()]);
            }
        });
        if (processingItemArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/compiler/J2MEPreverifier", "getProcessingItems"));
        }
        return processingItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileProcessingCompiler.ProcessingItem[] process(final CompileContext context, final FileProcessingCompiler.ProcessingItem[] items) {
        ProgressIndicator progressIndicator = context.getProgressIndicator();
        try {
            progressIndicator.pushState();
            progressIndicator.setText(J2MEBundle.message("compiler.preverifying.progress.title", new Object[0]));
            try {
                ActionRunner.runInsideWriteAction((ActionRunner.InterruptibleRunnable)new ActionRunner.InterruptibleRunnable(){

                    public void run() throws Exception {
                        LocalFileSystem.getInstance().refresh(false);
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            FileProcessingCompiler.ProcessingItem[] processingItemArray = (FileProcessingCompiler.ProcessingItem[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<FileProcessingCompiler.ProcessingItem[]>(){

                public FileProcessingCompiler.ProcessingItem[] compute() {
                    ArrayList<FileProcessingCompiler.ProcessingItem> processed = new ArrayList<FileProcessingCompiler.ProcessingItem>();
                    for (int i = 0; items != null && i < items.length; ++i) {
                        MyProcessingItem item = (MyProcessingItem)items[i];
                        ArrayList<VirtualFile> dependantClasspath = item.getDependantClasspath();
                        try {
                            FileUtil.copyDir((File)new File(item.myFromClasses.getPath().replace('/', File.separatorChar)), (File)item.getToClasses());
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                        Sdk jdk = item.getJdkToPreverify();
                        try {
                            GeneralCommandLine generalCommandLine = new GeneralCommandLine();
                            Emulator emulator = (Emulator)jdk.getSdkAdditionalData();
                            EmulatorType emulatorType = emulator.getEmulatorType();
                            generalCommandLine.setExePath(emulatorType.getPreverifyPath(jdk.getHomePath()));
                            String[] preverifyOptions = emulator.getPreverifyOptions();
                            if (preverifyOptions != null) {
                                generalCommandLine.addParameters(preverifyOptions);
                            }
                            generalCommandLine.addParameter("-d");
                            generalCommandLine.addParameter(item.getToClasses().getPath().replace(File.separatorChar, '/'));
                            generalCommandLine.addParameter("-classpath");
                            PathsList classpath = new PathsList();
                            classpath.addVirtualFiles(jdk.getRootProvider().getFiles(OrderRootType.CLASSES));
                            OrderEnumerator.orderEntries((Module)item.getModule()).librariesOnly().classes().collectPaths(classpath);
                            for (int k = 0; dependantClasspath != null && k < dependantClasspath.size(); ++k) {
                                classpath.add(PathUtil.getLocalPath((VirtualFile)dependantClasspath.get(k)));
                            }
                            generalCommandLine.addParameter(classpath.getPathsString());
                            generalCommandLine.addParameter(item.getFile().getPath());
                            generalCommandLine.setWorkDirectory(jdk.getHomePath());
                            OSProcessHandler osProcessHandler = new OSProcessHandler(generalCommandLine.createProcess(), generalCommandLine.getCommandLineString());
                            final ArrayList errors = new ArrayList();
                            osProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                                public void onTextAvailable(ProcessEvent event, Key outputType) {
                                    errors.add(event.getText());
                                }
                            });
                            osProcessHandler.startNotify();
                            osProcessHandler.waitFor();
                            J2MEPreverifier.this.printPreverifyErrors(errors, context);
                        }
                        catch (ExecutionException e) {
                            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                        }
                        processed.add(items[i]);
                    }
                    return processed.toArray(new FileProcessingCompiler.ProcessingItem[processed.size()]);
                }
            });
            return processingItemArray;
        }
        finally {
            progressIndicator.popState();
        }
    }

    private void printPreverifyErrors(ArrayList<String> errors, CompileContext context) {
        int noErrors = -1;
        for (int textIndex = 0; textIndex < errors.size() && noErrors == -1; ++textIndex) {
            String text = errors.get(textIndex);
            if (!StringUtil.containsIgnoreCase((String)text, (String)J2MEBundle.message("compiler.preverify.error", new Object[0]))) continue;
            noErrors = textIndex;
        }
        if (noErrors > -1) {
            for (int errorIdx = noErrors; errorIdx < errors.size(); ++errorIdx) {
                context.addMessage(CompilerMessageCategory.WARNING, this.getDescription() + errors.get(errorIdx), null, -1, -1);
            }
        }
    }

    public File getModulePreverifiedClasses(Module module) {
        return this.myModulePreverifiedClasses.get(module);
    }

    @NotNull
    public String getDescription() {
        String string = J2MEBundle.message("compiler.preverifier", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/compiler/J2MEPreverifier", "getDescription"));
        }
        return string;
    }

    public boolean validateConfiguration(final CompileScope scope) {
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                Module[] affectedModules = scope.getAffectedModules();
                if (affectedModules == null || affectedModules.length == 0) {
                    return Boolean.TRUE;
                }
                for (Module module : affectedModules) {
                    if (!ModuleType.get((Module)module).equals((Object)J2MEModuleType.getInstance())) continue;
                    Sdk projectJdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (!MobileSdk.checkCorrectness(projectJdk, module)) {
                        Messages.showErrorDialog((String)J2MEBundle.message("compiler.jdk.is.invalid", projectJdk != null ? projectJdk.getName() : "", module.getName()), (String)J2MEBundle.message("compiler.unable.to.compile", module.getName()));
                        return Boolean.FALSE;
                    }
                    MobileApplicationType mobileApplicationType = J2MEModuleProperties.getInstance(module).getMobileApplicationType();
                    MobileModuleSettings settings = MobileModuleSettings.getInstance(module);
                    LOG.assertTrue(settings != null);
                    if (settings.getSettings().get(mobileApplicationType.getJarUrlSettingName()) == null) {
                        Messages.showErrorDialog((String)J2MEBundle.message("compiler.jar.file.not.specified", new Object[0]), (String)J2MEBundle.message("compiler.unable.to.compile", module.getName()));
                        return Boolean.FALSE;
                    }
                    if (settings.getMobileDescriptionPath() != null) continue;
                    Messages.showErrorDialog((String)J2MEBundle.message("compiler.descriptor.file.not.specified", StringUtil.capitalize((String)mobileApplicationType.getExtension())), (String)J2MEBundle.message("compiler.unable.to.compile", module.getName()));
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        });
    }

    public ValidityState createValidityState(DataInput in) throws IOException {
        return new EmptyValidityState();
    }

    private static class MyProcessingItem
    implements FileProcessingCompiler.ProcessingItem {
        private EmptyValidityState myEmptyValidityState;
        private final VirtualFile myFromClasses;
        private final File myToClasses;
        private final Sdk myProjectJdk;
        private final Module myModule;
        private final ArrayList<VirtualFile> myDependantClasspath;

        public MyProcessingItem(VirtualFile fromClasses, Module module, File toClasses, Sdk projectJdk, ArrayList<VirtualFile> dependantClasspath) {
            this.myFromClasses = fromClasses;
            this.myToClasses = toClasses;
            this.myProjectJdk = projectJdk;
            this.myModule = module;
            this.myDependantClasspath = dependantClasspath;
            this.setValidityState();
        }

        public ArrayList<VirtualFile> getDependantClasspath() {
            return this.myDependantClasspath;
        }

        public File getToClasses() {
            return this.myToClasses;
        }

        public Sdk getJdkToPreverify() {
            return this.myProjectJdk;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFromClasses;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/compiler/J2MEPreverifier$MyProcessingItem", "getFile"));
            }
            return virtualFile;
        }

        public Module getModule() {
            return this.myModule;
        }

        public EmptyValidityState getValidityState() {
            return this.myEmptyValidityState;
        }

        public void setValidityState() {
            this.myEmptyValidityState = new EmptyValidityState();
        }
    }
}

