/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.EmulatorUtil;
import com.intellij.j2meplugin.emulator.MobileSdkUtil;
import com.intellij.j2meplugin.emulator.ui.MobileSdkConfigurable;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.JavaDependentSdkType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import icons.J2mepluginIcons;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobileSdk
extends JavaDependentSdkType
implements JavaSdkType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");

    public MobileSdk() {
        super("MobileSDK");
    }

    public String getPresentableName() {
        return J2MEBundle.message("jdk.type.name", new Object[0]);
    }

    public Icon getIcon() {
        return J2mepluginIcons.Sdk_closed;
    }

    public Icon getIconForAddAction() {
        return J2mepluginIcons.Add_sdk;
    }

    public static MobileSdk getInstance() {
        return (MobileSdk)SdkType.findInstance(MobileSdk.class);
    }

    public static boolean checkCorrectness(Sdk projectJdk, Module module) {
        EmulatorType emulatorType;
        if (projectJdk == null) {
            return false;
        }
        if (!projectJdk.getSdkType().equals((Object)MobileSdk.getInstance())) {
            return false;
        }
        if (!(projectJdk.getSdkAdditionalData() instanceof Emulator)) {
            return false;
        }
        Emulator emulator = (Emulator)projectJdk.getSdkAdditionalData();
        if (emulator.getHome() == null) {
            emulator.setHome(projectJdk.getHomePath());
        }
        if ((emulatorType = emulator.getEmulatorType()) == null) {
            return false;
        }
        Sdk javaSdk = emulator.getJavaSdk();
        if (javaSdk == null || !javaSdk.getSdkType().equals(JavaSdk.getInstance())) {
            return false;
        }
        return module == null || ModuleType.get((Module)module).equals((Object)J2MEModuleType.getInstance()) && J2MEModuleProperties.getInstance(module).getMobileApplicationType() != null;
    }

    @Nullable
    public static EmulatorType getEmulatorType(Sdk jdk, Module module) {
        if (MobileSdk.checkCorrectness(jdk, module)) {
            return ((Emulator)jdk.getSdkAdditionalData()).getEmulatorType();
        }
        return null;
    }

    public AdditionalDataConfigurable createAdditionalDataConfigurable(SdkModel sdkModel, SdkModificator sdkModificator) {
        return new MobileSdkConfigurable(sdkModel, sdkModificator);
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalData", "com/intellij/j2meplugin/emulator/MobileSdk", "saveAdditionalData"));
        }
        if (additional == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additional", "com/intellij/j2meplugin/emulator/MobileSdk", "saveAdditionalData"));
        }
        if (!(additionalData instanceof Emulator)) {
            return;
        }
        try {
            ((Emulator)additionalData).writeExternal(additional);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
    }

    public SdkAdditionalData loadAdditionalData(Element additional) {
        Emulator emulator = new Emulator();
        try {
            emulator.readExternal(additional);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return emulator;
    }

    public String getBinPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/j2meplugin/emulator/MobileSdk", "getBinPath"));
        }
        if (!MobileSdk.checkCorrectness(sdk, null)) {
            return null;
        }
        Sdk mySdk = ((Emulator)sdk.getSdkAdditionalData()).getJavaSdk();
        LOG.assertTrue(mySdk != null);
        return ((JavaSdk)mySdk.getSdkType()).getBinPath(mySdk);
    }

    public String getToolsPath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/j2meplugin/emulator/MobileSdk", "getToolsPath"));
        }
        if (!MobileSdk.checkCorrectness(sdk, null)) {
            return null;
        }
        Sdk mySdk = ((Emulator)sdk.getSdkAdditionalData()).getJavaSdk();
        LOG.assertTrue(mySdk != null);
        return ((JavaSdk)mySdk.getSdkType()).getToolsPath(mySdk);
    }

    public String getVMExecutablePath(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/j2meplugin/emulator/MobileSdk", "getVMExecutablePath"));
        }
        if (!MobileSdk.checkCorrectness(sdk, null)) {
            return null;
        }
        Sdk mySdk = ((Emulator)sdk.getSdkAdditionalData()).getJavaSdk();
        LOG.assertTrue(mySdk != null);
        return ((JavaSdk)mySdk.getSdkType()).getVMExecutablePath(mySdk);
    }

    public String suggestHomePath() {
        return null;
    }

    public boolean isValidSdkHome(String path) {
        return EmulatorUtil.getValidEmulatorType(path) != null;
    }

    public String getVersionString(String sdkHome) {
        return "1.3";
    }

    @Nullable
    public String suggestSdkName(String currentSdkName, String sdkHome) {
        EmulatorType emulatorType = EmulatorUtil.getValidEmulatorType(sdkHome);
        if (emulatorType != null) {
            return emulatorType.suggestName(sdkHome);
        }
        return null;
    }

    public void setupSdkPaths(@NotNull Sdk sdk) {
        File api;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/intellij/j2meplugin/emulator/MobileSdk", "setupSdkPaths"));
        }
        VirtualFile[] classes = null;
        File mobileJdkHome = new File(sdk.getHomePath());
        EmulatorType emulatorType = EmulatorUtil.getValidEmulatorType(sdk.getHomePath());
        LOG.assertTrue(emulatorType != null);
        String[] apiClasses = emulatorType.getApi(sdk.getHomePath());
        if (apiClasses != null) {
            classes = MobileSdkUtil.findApiClasses(apiClasses);
        }
        if (classes == null || classes.length == 0) {
            classes = MobileSdkUtil.findApiClasses(mobileJdkHome);
        }
        ArrayList<VirtualFile> docs = new ArrayList<VirtualFile>();
        String docsString = "docs";
        String apiString = "api";
        String docString = "doc";
        File file = new File(new File(mobileJdkHome, "docs"), "api").exists() ? new File(new File(mobileJdkHome, "docs"), "api") : (api = new File(new File(mobileJdkHome, "doc"), "api").exists() ? new File(new File(mobileJdkHome, "doc"), "api") : null);
        if (api != null) {
            MobileSdkUtil.findDocs(api, docs);
        } else {
            MobileSdkUtil.findDocs(mobileJdkHome, docs);
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        for (int i = 0; classes != null && i < classes.length; ++i) {
            sdkModificator.addRoot(classes[i], OrderRootType.CLASSES);
        }
        for (VirtualFile doc : docs) {
            sdkModificator.addRoot(doc, JavadocOrderRootType.getInstance());
        }
        sdkModificator.setSdkAdditionalData((SdkAdditionalData)new Emulator(emulatorType, null, EmulatorUtil.findFirstJavaSdk(), sdk.getHomePath()));
        sdkModificator.commitChanges();
    }
}

