/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator.midp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.ui.MobileApiSettingsEditor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.util.Key;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MIDPEmulatorType
extends EmulatorType {
    protected static final String SDK_NAME = "_SDK_NAME";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");

    @Override
    @NonNls
    public String getApplicationType() {
        return "MIDP";
    }

    @Override
    @NonNls
    @Nullable
    public String getDescriptorOption() {
        return "-Xdescriptor:";
    }

    @Override
    @Nullable
    @NonNls
    public String getDeviceOption() {
        return "-Xdevice:";
    }

    @Override
    @Nullable
    @NonNls
    public String getRelativePathToEmulator() {
        return "bin/emulator";
    }

    protected Properties getVersionProperties(String home) {
        String emulatorExe = this.getPathToEmulator(home);
        if (emulatorExe == null || emulatorExe.length() < 1) {
            return null;
        }
        String versionOutput = MIDPEmulatorType.getExeOutput(emulatorExe, "-version");
        if (versionOutput == null || versionOutput.length() < 4) {
            return null;
        }
        return MIDPEmulatorType.convertVersionOutputToProperties(versionOutput);
    }

    static Properties convertVersionOutputToProperties(String versionOutput) {
        String line;
        BufferedReader versionOutputLines = new BufferedReader(new StringReader(versionOutput), 512);
        int lineNumber = 0;
        Properties props = new Properties();
        while ((line = MIDPEmulatorType.readLine(versionOutputLines)) != null) {
            int colon;
            if (lineNumber == 1) {
                props.setProperty(SDK_NAME, line);
            } else if (lineNumber > 1 && (colon = line.indexOf(58)) > 0 && colon + 1 < line.length()) {
                String key = line.substring(0, colon);
                String value = line.substring(colon + 1).trim();
                props.setProperty(key, value);
            }
            ++lineNumber;
        }
        return props;
    }

    @Nullable
    private static String readLine(BufferedReader br) {
        try {
            return br.readLine();
        }
        catch (IOException ignored) {
            return null;
        }
    }

    @Nullable
    protected static String getExeOutput(String exe, String param) {
        final StringBuffer output = new StringBuffer();
        if (exe == null || exe.length() < 1) {
            return null;
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(exe);
        generalCommandLine.addParameter(param);
        try {
            OSProcessHandler osProcessHandler = new OSProcessHandler(generalCommandLine.createProcess(), generalCommandLine.getCommandLineString());
            osProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    output.append(event.getText());
                }
            });
            osProcessHandler.startNotify();
            osProcessHandler.waitFor();
            osProcessHandler.destroyProcess();
        }
        catch (ExecutionException e) {
            LOG.debug((Throwable)e);
            return null;
        }
        return output.toString();
    }

    @Override
    @Nullable
    public String suggestName(String homePath) {
        Properties versionProps = this.getVersionProperties(homePath);
        if (versionProps == null) {
            return null;
        }
        return versionProps.getProperty(SDK_NAME);
    }

    @NonNls
    public abstract String getDefaultProfile(@NotNull String var1);

    public String[] getAvailableProfiles(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/j2meplugin/emulator/midp/MIDPEmulatorType", "getAvailableProfiles"));
        }
        return new String[]{this.getDefaultProfile(homePath)};
    }

    @NonNls
    public abstract String getDefaultConfiguration(@NotNull String var1);

    public String[] getAvailableConfigurations(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/j2meplugin/emulator/midp/MIDPEmulatorType", "getAvailableConfigurations"));
        }
        return new String[]{this.getDefaultConfiguration(homePath)};
    }

    public abstract MobileApiSettingsEditor getApiEditor(String var1, Sdk var2, SdkModificator var3);
}

