/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.emulator.midp.wtk;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.midp.MIDPEmulatorType;
import com.intellij.j2meplugin.emulator.midp.uei.UnifiedEmulatorType;
import com.intellij.j2meplugin.emulator.midp.wtk.ConfigurationUtil;
import com.intellij.j2meplugin.emulator.midp.wtk.WTKApiEditor;
import com.intellij.j2meplugin.emulator.ui.MobileApiSettingsEditor;
import com.intellij.j2meplugin.emulator.ui.MobileDefaultApiEditor;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.j2meplugin.run.J2MERunnableState;
import com.intellij.j2meplugin.run.states.midp.uei.UEIRunnableState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WTKEmulatorType
extends MIDPEmulatorType {
    @NonNls
    private static final String PROFILES = "profiles";
    @NonNls
    private static final String CONFIGURATIONS = "configurations";
    public static final String EMULATOR_TYPE_NAME = J2MEBundle.message("emulator.wtk.fullname", new Object[0]);

    @Override
    @NonNls
    public String getName() {
        return EMULATOR_TYPE_NAME;
    }

    @Override
    @Nullable
    @NonNls
    public String getUtilPath(String home) {
        return WTKEmulatorType.toSystemDependentPath(home, "bin/utils");
    }

    @Override
    @Nullable
    @NonNls
    public String getPrefPath(String home) {
        return WTKEmulatorType.toSystemDependentPath(home, "bin/prefs");
    }

    @Override
    public boolean isValidHomeDirectory(String homePath) {
        return ConfigurationUtil.isValidWTKHome(homePath);
    }

    @Override
    public String[] getAvailableSkins(String homePath) {
        String[] devices;
        String exePath = this.getPathToEmulator(homePath);
        if (exePath != null && (devices = UnifiedEmulatorType.fillEmulatorDevices(exePath)) != null) {
            return devices;
        }
        return ConfigurationUtil.getWTKDevices(homePath);
    }

    @Override
    public String[] getOTACommands() {
        return new String[]{"install", "force", "run", "remove", "transient", "storageNames"};
    }

    @Override
    public String[] getApi(String homePath) {
        return ConfigurationUtil.getDefaultApiPath(homePath);
    }

    @Override
    public MobileApiSettingsEditor getApiEditor(String homePath, Sdk sdk, SdkModificator sdkModificator) {
        Properties apiSettings = ConfigurationUtil.getApiSettings(homePath);
        if (apiSettings == null || apiSettings.isEmpty()) {
            return new MobileDefaultApiEditor();
        }
        return new WTKApiEditor(this, sdk, sdkModificator);
    }

    @Override
    public J2MERunnableState getJ2MERunnableState(Executor executor, RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSetting, J2MERunConfiguration configuration, Project project, Sdk projectJdk) {
        return new UEIRunnableState(runnerSettings, configurationSetting, configuration, project, projectJdk);
    }

    @Override
    public String[] getAvailableProfiles(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/j2meplugin/emulator/midp/wtk/WTKEmulatorType", "getAvailableProfiles"));
        }
        return WTKEmulatorType.getExistSettings(homePath, PROFILES);
    }

    @Override
    public String[] getAvailableConfigurations(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/j2meplugin/emulator/midp/wtk/WTKEmulatorType", "getAvailableConfigurations"));
        }
        return WTKEmulatorType.getExistSettings(homePath, CONFIGURATIONS);
    }

    static String[] getExistSettings(String homePath, String settingName) {
        Properties properties = ConfigurationUtil.getApiSettings(homePath);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        String profiles = properties.getProperty(settingName);
        if (profiles == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] values = profiles.split("[, \n]");
        for (int i = 0; values != null && i < values.length; ++i) {
            String value = values[i];
            String stringInJad = properties.getProperty(value + ".jadValue");
            if (stringInJad == null || stringInJad.length() == 0) continue;
            result.add(stringInJad.trim());
        }
        return ArrayUtil.toStringArray(result);
    }

    @Override
    public String getDefaultProfile(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/j2meplugin/emulator/midp/wtk/WTKEmulatorType", "getDefaultProfile"));
        }
        return ConfigurationUtil.getProfileVersion(homePath);
    }

    @Override
    public String getDefaultConfiguration(@NotNull String homePath) {
        if (homePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "homePath", "com/intellij/j2meplugin/emulator/midp/wtk/WTKEmulatorType", "getDefaultConfiguration"));
        }
        return ConfigurationUtil.getConfigurationVersion(homePath);
    }

    public static WTKEmulatorType getInstance() {
        return (WTKEmulatorType)ApplicationManager.getApplication().getComponent(WTKEmulatorType.class);
    }
}

