/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings;

import com.intellij.j2meplugin.compiler.MobileMakeUtil;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.general.UserDefinedOption;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ActionRunner;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;

public abstract class MobileSettingsConfigurable
implements UnnamedConfigurable {
    protected MobileModuleSettings mySettings;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    protected Module myModule;
    protected Project myProject;

    protected MobileSettingsConfigurable(Module module, MobileModuleSettings settings, Project project) {
        this.mySettings = settings;
        this.myModule = module;
        this.myProject = project;
    }

    public abstract void disableMidletProperties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        block8: {
            if (this.mySettings.isSynchronized()) {
                try {
                    ActionRunner.runInsideWriteAction((ActionRunner.InterruptibleRunnable)new ActionRunner.InterruptibleRunnable(){

                        public void run() throws Exception {
                            Document document;
                            VirtualFile descriptor = LocalFileSystem.getInstance().refreshAndFindFileByPath(MobileSettingsConfigurable.this.mySettings.getMobileDescriptionPath().replace(File.separatorChar, '/'));
                            FileDocumentManager documentManager = FileDocumentManager.getInstance();
                            if (descriptor != null && (document = documentManager.getDocument(descriptor)) != null) {
                                documentManager.saveDocument(document);
                            }
                        }
                    });
                    Properties properties = new Properties();
                    File descriptor = new File(this.mySettings.getMobileDescriptionPath());
                    if (!descriptor.exists()) break block8;
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(descriptor));
                    try {
                        properties.load(is);
                        this.mySettings.getSettings().clear();
                        this.mySettings.getUserDefinedOptions().clear();
                        for (Object o : properties.keySet()) {
                            String key = (String)o;
                            if (this.mySettings.getApplicationType().isUserField(key)) {
                                this.mySettings.getUserDefinedOptions().add(new UserDefinedOption(key, properties.getProperty(key)));
                                continue;
                            }
                            this.mySettings.getSettings().put(key, properties.getProperty(key));
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public void apply() throws ConfigurationException {
        if (this.mySettings.isSynchronized()) {
            try {
                MobileMakeUtil.makeJad(this.mySettings, false);
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage());
            }
        }
    }

    public MobileModuleSettings getSettings() {
        return this.mySettings;
    }
}

