/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.ui;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.MobileSettingsConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class J2MEModuleConfEditor
implements ModuleConfigurationEditor {
    private JPanel myWholePanel;
    private JPanel mySettingsPanel;
    private JCheckBox myUseUserDefinedJad;
    private MobileSettingsConfigurable mySettingsConfigurable;
    private MobileModuleSettings myModuleSettings;
    private final Module myModule;
    private final Project myProject;

    public J2MEModuleConfEditor(Module module, Project project) {
        this.myModule = module;
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    public void disposeUIResources() {
        if (this.mySettingsConfigurable != null) {
            this.mySettingsConfigurable.disposeUIResources();
        }
    }

    public MobileApplicationType getApplicationType(Module module) {
        return J2MEModuleProperties.getInstance(module).getMobileApplicationType();
    }

    public MobileModuleSettings getModuleSettings(Module module) {
        return MobileModuleSettings.getInstance(module);
    }

    public void reset() {
        this.mySettingsConfigurable.reset();
        this.myUseUserDefinedJad.setSelected(this.myModuleSettings.isSynchronized());
    }

    public void apply() throws ConfigurationException {
        this.myModuleSettings.setSynchronized(this.myUseUserDefinedJad.isSelected());
        this.mySettingsConfigurable.apply();
    }

    public boolean isModified() {
        return this.myUseUserDefinedJad.isSelected() != this.myModuleSettings.isSynchronized() || this.mySettingsConfigurable.isModified();
    }

    public String getHelpTopic() {
        return "j2me.support.mobile.module.settings";
    }

    public String getDisplayName() {
        return J2MEBundle.message("mobile.module.settings.title", new Object[0]);
    }

    public void moduleStateChanged() {
    }

    public void saveData() {
    }

    public JPanel createComponent() {
        this.myModuleSettings = this.getModuleSettings(this.myModule);
        MobileApplicationType applicationType = this.getApplicationType(this.myModule);
        this.mySettingsConfigurable = applicationType.createConfigurable(this.myProject, this.myModule, this.myModuleSettings);
        this.mySettingsPanel.removeAll();
        this.mySettingsPanel.add((Component)this.mySettingsConfigurable.createComponent(), "Center");
        this.myUseUserDefinedJad.setText(J2MEBundle.message("module.settings.synchronization.needed", applicationType.getExtension().toUpperCase()));
        this.myUseUserDefinedJad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (J2MEModuleConfEditor.this.myUseUserDefinedJad.isSelected() && new File(J2MEModuleConfEditor.this.mySettingsConfigurable.getSettings().getMobileDescriptionPath()).exists()) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            VirtualFile descriptor = LocalFileSystem.getInstance().refreshAndFindFileByPath(J2MEModuleConfEditor.this.mySettingsConfigurable.getSettings().getMobileDescriptionPath().replace(File.separatorChar, '/'));
                            FileDocumentManager documentManager = FileDocumentManager.getInstance();
                            documentManager.saveDocument(documentManager.getDocument(descriptor));
                        }
                    });
                }
            }
        });
        return this.myWholePanel;
    }

    public void disableMidletProperties() {
        this.mySettingsConfigurable.disableMidletProperties();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myWholePanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(15, 5, 5, 5), -1, -1, false, false));
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(250, -1), null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseUserDefinedJad = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("module.settings.synchronization.needed.common"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 4, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

