/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.ui;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.module.J2MEModuleExtension;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.ui.MobileBuildPanel;
import com.intellij.j2meplugin.module.settings.ui.MobileExplodedPanel;
import com.intellij.j2meplugin.module.settings.ui.MobileModuleResourcesSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class MobileBuildSettings
implements ModuleConfigurationEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    private final Module myModule;
    private final ModifiableRootModel myRootModel;
    private final MobileExplodedPanel myExplodedPanel;
    private final MobileBuildPanel myBuildPanel;
    private final MobileModuleResourcesSettings myResourcesSettings;

    public MobileBuildSettings(Module module, ModifiableRootModel rootModel) {
        this.myModule = module;
        this.myRootModel = rootModel;
        J2MEModuleExtension extension = (J2MEModuleExtension)((Object)rootModel.getModuleExtension(J2MEModuleExtension.class));
        VirtualFile explodedDirectory = extension.getExplodedDirectory();
        String defaultExplodedPath = explodedDirectory != null ? explodedDirectory.getPath() : (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                String output = "output";
                return new File(MobileBuildSettings.this.myModule.getModuleFilePath()).getParent().replace('/', File.separatorChar) + File.separatorChar + "output";
            }
        });
        this.myExplodedPanel = new MobileExplodedPanel(explodedDirectory != null, extension.isExcludeExplodedDirectory(), defaultExplodedPath);
        MobileModuleSettings mobileModuleSettings = MobileModuleSettings.getInstance(this.myModule);
        this.myBuildPanel = new MobileBuildPanel(J2MEModuleProperties.getInstance(this.myModule).getMobileApplicationType(), this.myModule.getProject(), mobileModuleSettings);
        this.myResourcesSettings = new MobileModuleResourcesSettings(module, rootModel);
    }

    public void saveData() {
    }

    public void moduleStateChanged() {
    }

    public String getDisplayName() {
        return J2MEBundle.message("mobile.build.settings.title", new Object[0]);
    }

    public String getHelpTopic() {
        return "j2me.moduleJ2ME";
    }

    public JComponent createComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myBuildPanel.createComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
        panel.add((Component)this.myExplodedPanel.getComponent(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
        JPanel resourcesPanel = (JPanel)this.myResourcesSettings.createComponent();
        resourcesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.myResourcesSettings.getDisplayName(), (boolean)true));
        panel.add((Component)resourcesPanel, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        return panel;
    }

    public boolean isModified() {
        return this.myBuildPanel.isModified() || this.myExplodedPanel.isModified() || this.myResourcesSettings.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myBuildPanel.apply();
        this.myExplodedPanel.apply();
        J2MEModuleExtension extension = (J2MEModuleExtension)((Object)this.myRootModel.getModuleExtension(J2MEModuleExtension.class));
        if (this.myExplodedPanel.isPathEnabled()) {
            String canonicalPath;
            final String path = this.myExplodedPanel.getExplodedDir();
            if (!new File(path).exists()) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        String pathDir = FileUtil.toSystemIndependentName((String)path);
                        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(pathDir);
                        if (file == null) {
                            final File ioFile = new File(path);
                            CommandProcessor.getInstance().executeCommand(MobileBuildSettings.this.myModule.getProject(), new Runnable(){

                                @Override
                                public void run() {
                                    FileUtil.createParentDirs((File)ioFile);
                                    VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile.getParentFile());
                                    if (dir != null) {
                                        try {
                                            dir.createChildDirectory((Object)this, ioFile.getName());
                                        }
                                        catch (IOException e) {
                                            LOG.error((Throwable)e);
                                        }
                                    }
                                }
                            }, J2MEBundle.message("exploded.directory.create.command", new Object[0]), null);
                        }
                    }
                });
            }
            try {
                canonicalPath = "".equals(path) ? null : new File(path).getCanonicalPath();
            }
            catch (IOException e) {
                canonicalPath = path;
            }
            String url = canonicalPath == null ? null : VirtualFileManager.constructUrl((String)"file", (String)canonicalPath.replace(File.separatorChar, '/'));
            extension.setExplodedDirectory(url);
            extension.setExcludeExplodedDirectory(this.myExplodedPanel.isExcludeFromContent());
        } else {
            VirtualFile exploded = null;
            extension.setExplodedDirectory(exploded);
        }
        this.myResourcesSettings.apply();
    }

    public void reset() {
        this.myBuildPanel.reset();
        this.myExplodedPanel.reset();
        this.myResourcesSettings.reset();
    }

    public void disposeUIResources() {
    }
}

