/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module.settings.ui;

import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MobileExplodedPanel {
    private final JPanel myExplodedPanel = new JPanel(new GridBagLayout());
    private final JLabel myExplanation;
    private final JCheckBox myUseExplodedDir;
    private final FieldPanel myExplodedDirectory;
    private String myExplodedPath;
    private boolean myUseExplodedDirectory;
    private boolean myExcludeFromContent;
    private final JCheckBox myExcludeFromModuleContent;
    private boolean myModified = false;

    public MobileExplodedPanel(boolean useExplodedDir, boolean excludeFromContent, String explodedDir) {
        this.myExplodedPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)J2MEBundle.message("exploded.directory.settings", new Object[0]), (boolean)true));
        this.myExplanation = new JLabel(J2MEBundle.message("exploded.directory.explanation", new Object[0]));
        this.myUseExplodedDir = new JCheckBox(J2MEBundle.message("exploded.directory.setup", new Object[0]));
        this.myExplodedDirectory = new FieldPanel();
        this.myExcludeFromModuleContent = new JCheckBox(J2MEBundle.message("exploded.directory.excluded", new Object[0]));
        this.myExplodedPanel.add((Component)this.myExplanation, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.myExplodedPanel.add((Component)this.myUseExplodedDir, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.myExplodedPanel.add((Component)this.myExplodedDirectory, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 13, 0, 0), 0, 0));
        this.myExplodedPanel.add((Component)this.myExcludeFromModuleContent, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.myExplodedPath = explodedDir;
        this.myUseExplodedDirectory = useExplodedDir;
        this.myExcludeFromContent = excludeFromContent;
    }

    public String getExplodedDir() {
        return this.myExplodedPath;
    }

    public boolean isExcludeFromContent() {
        return this.myExcludeFromContent;
    }

    public boolean isPathEnabled() {
        return this.myUseExplodedDirectory;
    }

    public JComponent getComponent() {
        this.myUseExplodedDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MobileExplodedPanel.this.myUseExplodedDir.isSelected()) {
                    if (MobileExplodedPanel.this.myExplodedDirectory.getText() == null || MobileExplodedPanel.this.myExplodedDirectory.getText().equals("")) {
                        MobileExplodedPanel.this.myExplodedDirectory.setText(MobileExplodedPanel.this.myExplodedPath);
                    }
                    MobileExplodedPanel.this.myExplodedDirectory.setEnabled(true);
                    MobileExplodedPanel.this.myExcludeFromModuleContent.setEnabled(true);
                } else {
                    MobileExplodedPanel.this.myExplodedDirectory.setEnabled(false);
                    MobileExplodedPanel.this.myExcludeFromModuleContent.setEnabled(false);
                }
                MobileExplodedPanel.this.myModified = true;
            }
        });
        final LocalFileSystem lfs = LocalFileSystem.getInstance();
        this.myExplodedDirectory.setBrowseButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualFile file;
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                descriptor.setTitle(J2MEBundle.message("exploded.directory.chooser.title", new Object[0]));
                descriptor.setDescription(J2MEBundle.message("exploded.directory.chooser", new Object[0]));
                VirtualFile toSelect = null;
                if (MobileExplodedPanel.this.myExplodedDirectory.getText() != null) {
                    toSelect = lfs.findFileByPath(MobileExplodedPanel.this.myExplodedDirectory.getText().replace(File.separatorChar, '/'));
                }
                if ((file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)MobileExplodedPanel.this.myExplodedPanel, null, toSelect)) != null) {
                    MobileExplodedPanel.this.myExplodedDirectory.setText(FileUtil.toSystemDependentName((String)file.getPath()));
                }
            }
        });
        this.myExplodedDirectory.createComponent();
        this.myExplodedDirectory.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MobileExplodedPanel.this.myModified = true;
            }
        });
        this.myExcludeFromModuleContent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobileExplodedPanel.this.myModified = true;
            }
        });
        return this.myExplodedPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myUseExplodedDir;
    }

    public void reset() {
        if (this.myUseExplodedDirectory) {
            this.myExplodedDirectory.setText(this.myExplodedPath);
            this.myExcludeFromModuleContent.setSelected(this.myExcludeFromContent);
        }
        this.myExplodedDirectory.setEnabled(this.myUseExplodedDirectory);
        this.myExcludeFromModuleContent.setEnabled(this.myUseExplodedDirectory);
        this.myUseExplodedDir.setSelected(this.myUseExplodedDirectory);
        this.myModified = false;
    }

    public void apply() {
        this.myUseExplodedDirectory = this.myUseExplodedDir.isSelected();
        this.myExplodedPath = this.myUseExplodedDirectory ? this.myExplodedDirectory.getText() : null;
        this.myExcludeFromContent = this.myExcludeFromModuleContent.isSelected();
        this.myModified = false;
    }

    public boolean isModified() {
        return this.myModified;
    }
}

