/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.run;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.PatchedRunnableState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.general.UserDefinedOption;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class J2MERunnableState
implements PatchedRunnableState {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    protected RunnerSettings myRunnerSettings;
    protected ConfigurationPerRunnerSettings myConfigurationSetting;
    protected J2MERunConfiguration myConfiguration;
    protected Sdk myProjectJdk;
    protected Project myProject;
    protected ArrayList<File> myFilesToDelete = new ArrayList();
    private String myDebugPort = "";

    public J2MERunnableState(RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSetting, J2MERunConfiguration configuration, Project project, Sdk projectJdk) {
        this.myRunnerSettings = runnerSettings;
        this.myConfigurationSetting = configurationSetting;
        this.myConfiguration = configuration;
        this.myProject = project;
        this.myProjectJdk = projectJdk;
        if (this.myRunnerSettings instanceof DebuggingRunnerData) {
            this.myDebugPort = ((DebuggingRunnerData)this.myRunnerSettings).getDebugPort();
            if (this.myDebugPort.length() == 0) {
                try {
                    this.myDebugPort = DebuggerUtils.getInstance().findAvailableDebugAddress(true);
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
                ((DebuggingRunnerData)this.myRunnerSettings).setDebugPort(this.myDebugPort);
            }
            ((DebuggingRunnerData)this.myRunnerSettings).setLocal(false);
        }
    }

    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        if (runner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runner", "com/intellij/j2meplugin/run/J2MERunnableState", "execute"));
        }
        if (this.myProjectJdk == null) {
            throw new ExecutionException(J2MEBundle.message("run.configuration.invalid.jdk", new Object[0]));
        }
        EmulatorType emulatorType = ((Emulator)this.myProjectJdk.getSdkAdditionalData()).getEmulatorType();
        LOG.assertTrue(emulatorType != null);
        MobileApplicationType mobileApplicationType = MobileModuleUtil.getMobileApplicationTypeByName(emulatorType.getApplicationType());
        if (!this.myConfiguration.IS_OTA) {
            if (this.myConfiguration.IS_CLASSES) {
                if (this.myConfiguration.MAIN_CLASS_NAME == null || this.myConfiguration.MAIN_CLASS_NAME.length() == 0) {
                    throw new ExecutionException(J2MEBundle.message("run.configuration.no.class.specified", mobileApplicationType.getPresentableClassName()));
                }
            } else {
                if (this.myConfiguration.JAD_NAME == null || this.myConfiguration.JAD_NAME.length() == 0) {
                    throw new ExecutionException(J2MEBundle.message("run.configuration.no.file.specified", mobileApplicationType.getExtension()));
                }
                if (!this.myConfiguration.JAD_NAME.endsWith(mobileApplicationType.getExtension())) {
                    throw new ExecutionException(J2MEBundle.message("run.configuration.mistyped.descriptor", this.myConfiguration.JAD_NAME, mobileApplicationType.getName()));
                }
            }
        } else if (this.myConfiguration.TO_START == null || this.myConfiguration.TO_START.length() == 0) {
            throw new ExecutionException(J2MEBundle.message("run.configuration.no.file.specified", mobileApplicationType.getExtension()));
        }
        ConsoleView console = TextConsoleBuilderFactory.getInstance().createBuilder(this.myProject).getConsole();
        ProcessHandler processHandler = this.getExecutionProcess(this.myDebugPort);
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                for (File file : J2MERunnableState.this.myFilesToDelete) {
                    if (file == null || !file.exists()) continue;
                    FileUtil.delete((File)file);
                }
            }
        });
        console.attachToProcess(processHandler);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        return new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    protected ProcessHandler getExecutionProcess(String availablePort) throws ExecutionException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private File createTempJad(Module module) {
        PrintWriter printWriter = null;
        try {
            MobileApplicationType mobileApplicationType = J2MEModuleProperties.getInstance(module).getMobileApplicationType();
            MobileModuleSettings settings = MobileModuleSettings.getInstance(module);
            String separator = mobileApplicationType.getSeparator();
            String prefix = "temp";
            String childName = "caches";
            File jadFile = FileUtil.createTempFile((File)new File(PathManager.getSystemPath(), "caches"), (String)"temp", (String)("." + mobileApplicationType.getExtension()), (boolean)true);
            jadFile.deleteOnExit();
            File jarFile = new File(settings.getJarURL());
            if (!jarFile.exists()) {
                File file = null;
                return file;
            }
            settings.prepareJarSettings();
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(jadFile)));
            printWriter.println(mobileApplicationType.createConfigurationByClass(this.myConfiguration.MAIN_CLASS_NAME));
            String jarExtension = ".jar";
            printWriter.println(mobileApplicationType.getJarUrlSettingName() + separator + " " + jadFile.getName().replaceAll("." + mobileApplicationType.getExtension(), ".jar"));
            for (String string : settings.getSettings().keySet()) {
                if (settings.isMidletKey(string) || string.equals(mobileApplicationType.getJarUrlSettingName())) continue;
                printWriter.println(string + separator + " " + settings.getSettings().get(string));
            }
            for (UserDefinedOption userDefinedOption : this.myConfiguration.userParameters) {
                printWriter.println(userDefinedOption.getKey() + separator + " " + userDefinedOption.getValue());
            }
            printWriter.close();
            File file = jadFile;
            return file;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return null;
    }

    protected File findFilesToDelete(Module module) throws ExecutionException {
        File tempJad = this.createTempJad(module);
        if (tempJad == null) {
            throw new ExecutionException(J2MEBundle.message("run.configuration.rebuild.needed", new Object[0]));
        }
        MobileApplicationType mobileApplicationType = J2MEModuleProperties.getInstance(module).getMobileApplicationType();
        MobileModuleSettings settings = MobileModuleSettings.getInstance(module);
        this.myFilesToDelete.add(tempJad);
        String jarExtension = ".jar";
        File toJarFile = new File(tempJad.getPath().replaceAll("." + mobileApplicationType.getExtension(), ".jar"));
        this.myFilesToDelete.add(toJarFile);
        try {
            FileUtil.copy((File)new File(FileUtil.toSystemDependentName((String)settings.getJarURL())), (File)toJarFile);
        }
        catch (IOException e) {
            throw new ExecutionException(e.getMessage());
        }
        return tempJad;
    }
}

