/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.run.states.midp.uei;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.j2meplugin.run.J2MERunnableState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.util.PathUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class UEIRunnableState
extends J2MERunnableState {
    public UEIRunnableState(RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSetting, J2MERunConfiguration configuration, Project project, Sdk projectJdk) {
        super(runnerSettings, configurationSetting, configuration, project, projectJdk);
    }

    @Override
    protected ProcessHandler getExecutionProcess(String availablePort) throws ExecutionException {
        Emulator emulator = (Emulator)this.myProjectJdk.getSdkAdditionalData();
        EmulatorType emulatorType = emulator.getEmulatorType();
        LOG.assertTrue(emulatorType != null);
        Module module = this.myConfiguration.getModule();
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(emulatorType.getPathToEmulator(this.myProjectJdk.getHomePath()));
        if (!this.myConfiguration.IS_OTA) {
            generalCommandLine.addParameter("-classpath");
            String[] urls = this.myProjectJdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            String classpath = "";
            for (int k = 0; urls != null && k < urls.length; ++k) {
                classpath = classpath + PathUtil.toPresentableUrl((String)urls[k]) + File.pathSeparator;
            }
            if (!this.myConfiguration.IS_CLASSES) {
                Properties properties = new Properties();
                try {
                    properties.load(new BufferedInputStream(new FileInputStream(this.myConfiguration.JAD_NAME)));
                }
                catch (IOException e) {
                    throw new ExecutionException(e.getMessage());
                }
                String jar = properties.getProperty("MIDlet-Jar-URL");
                if (jar == null) {
                    throw new ExecutionException(J2MEBundle.message("run.configuration.jar.not.specified.error", new Object[0]));
                }
                if (!new File(jar).exists()) {
                    jar = this.myConfiguration.JAD_NAME.substring(0, this.myConfiguration.JAD_NAME.lastIndexOf(File.separator) + 1) + jar;
                }
                classpath = classpath + jar;
                generalCommandLine.addParameter(classpath);
                generalCommandLine.addParameter(emulatorType.getDescriptorOption() + this.myConfiguration.JAD_NAME);
            } else {
                File tempJad = this.findFilesToDelete(module);
                classpath = classpath + MobileModuleSettings.getInstance(module).getJarURL();
                generalCommandLine.addParameter(classpath);
                generalCommandLine.addParameter(emulatorType.getDescriptorOption() + tempJad.getPath());
            }
        } else {
            String[] commands = (UEIRunnableState.getJAMCommand(this.myConfiguration.SELECTION) + this.myConfiguration.TO_START).split(" ");
            generalCommandLine.addParameters(commands);
        }
        if (this.myRunnerSettings instanceof DebuggingRunnerData) {
            generalCommandLine.addParameter("-Xdebug");
            generalCommandLine.addParameter("-Xrunjdwp:transport=dt_socket,address=" + availablePort + ",server=y");
        }
        if (this.myConfiguration.TARGET_DEVICE_NAME != null && this.myConfiguration.TARGET_DEVICE_NAME.length() > 0) {
            generalCommandLine.addParameter(emulatorType.getDeviceOption() + this.myConfiguration.TARGET_DEVICE_NAME);
        }
        if (this.myConfiguration.COMMAND_LINE_PARAMETERS != null && this.myConfiguration.COMMAND_LINE_PARAMETERS.length() > 0) {
            generalCommandLine.addParameter(this.myConfiguration.COMMAND_LINE_PARAMETERS);
        }
        generalCommandLine.setWorkDirectory(this.myProjectJdk.getHomePath());
        return new OSProcessHandler(generalCommandLine.createProcess(), generalCommandLine.getCommandLineString());
    }

    public static String getJAMCommand(int command) {
        String result = "-Xjam:";
        if (command == 1) {
            result = result + "install";
        } else if (command == 3) {
            result = result + "run";
        } else if (command == 2) {
            result = result + "remove";
        } else if (command == 4) {
            result = result + "transient";
        }
        return result + "=";
    }
}

