/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.run.ui.editors;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EmulatorEditor
implements UnnamedConfigurable {
    private JPanel myDeviceOptionsPanel;
    private JButton myPreferencesButton;
    private final DefaultComboBoxModel myDevicesList;
    private JComboBox myDevices;
    private JButton myUtilButton;
    private JPanel myDevicesPanel;
    private boolean myModified;
    private final Sdk myProjectJdk;
    private final J2MERunConfiguration myConfiguration;
    private final String[] myDeviceNames;
    private static final Logger LOG = Logger.getInstance((String)("#" + EmulatorEditor.class.getName()));

    public EmulatorEditor(J2MERunConfiguration j2merc, String[] devices, Sdk projectJdk) {
        this.$$$setupUI$$$();
        this.myDevicesList = new DefaultComboBoxModel();
        this.myModified = false;
        this.myConfiguration = j2merc;
        this.myProjectJdk = projectJdk;
        this.myDeviceNames = devices;
        final EmulatorType emulatorType = this.getEmulatorType();
        this.myPreferencesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String prefPath = emulatorType.getPrefPath(EmulatorEditor.this.myProjectJdk.getHomePath());
                GeneralCommandLine generalCommandLine = new GeneralCommandLine();
                generalCommandLine.setExePath(prefPath);
                generalCommandLine.setWorkDirectory(EmulatorEditor.this.myProjectJdk.getHomePath() + File.separator + "bin");
                EmulatorEditor.startExternalProcess(generalCommandLine);
            }
        });
        this.myUtilButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String utilPath = emulatorType.getUtilPath(EmulatorEditor.this.myProjectJdk.getHomePath());
                GeneralCommandLine generalCommandLine = new GeneralCommandLine();
                generalCommandLine.setExePath(utilPath);
                EmulatorEditor.startExternalProcess(generalCommandLine);
            }
        });
    }

    private static void startExternalProcess(GeneralCommandLine generalCommandLine) {
        try {
            OSProcessHandler osProcessHandler = new OSProcessHandler(generalCommandLine.createProcess(), generalCommandLine.getCommandLineString());
            osProcessHandler.startNotify();
            osProcessHandler.waitFor();
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
        }
    }

    public boolean isVisible() {
        return this.myDevicesPanel.isVisible() || this.myPreferencesButton.isVisible() || this.myUtilButton.isVisible();
    }

    public JComponent createComponent() {
        if (this.myDeviceNames != null) {
            this.myDevicesPanel.setVisible(true);
            this.myDevicesList.removeAllElements();
            for (String deviceName : this.myDeviceNames) {
                this.myDevicesList.addElement(deviceName);
            }
            this.myDevices.setModel(this.myDevicesList);
            this.myDevices.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EmulatorEditor.this.myModified = true;
                }
            });
        } else {
            this.myDevicesPanel.setVisible(false);
        }
        EmulatorType emulatorType = this.getEmulatorType();
        if (emulatorType.getPrefPath(this.myProjectJdk.getHomePath()) == null) {
            this.myPreferencesButton.setVisible(false);
        }
        if (emulatorType.getUtilPath(this.myProjectJdk.getHomePath()) == null) {
            this.myUtilButton.setVisible(false);
        }
        return this.myDeviceOptionsPanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() throws ConfigurationException {
        if (this.myDevicesPanel.isVisible()) {
            EmulatorType emulatorType = this.getEmulatorType();
            this.myConfiguration.TARGET_DEVICE_NAME = (String)this.myDevices.getSelectedItem();
        }
        this.myModified = false;
    }

    public void reset() {
        EmulatorType emulatorType = this.getEmulatorType();
        String device = emulatorType.getDeviceOption();
        if (device != null) {
            this.myDevicesPanel.setVisible(true);
            this.myDevices.setSelectedItem(this.myConfiguration.TARGET_DEVICE_NAME);
        } else {
            this.myDevicesPanel.setVisible(false);
        }
        this.myModified = false;
    }

    @NotNull
    private EmulatorType getEmulatorType() {
        EmulatorType emulatorType = ((Emulator)this.myProjectJdk.getSdkAdditionalData()).getEmulatorType();
        LOG.assertTrue(emulatorType != null);
        EmulatorType emulatorType2 = emulatorType;
        if (emulatorType2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/j2meplugin/run/ui/editors/EmulatorEditor", "getEmulatorType"));
        }
        return emulatorType2;
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JComboBox jComboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myDeviceOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDevicesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myDevices = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.emulator.device.chooser"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPreferencesButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.emulator.open.preferences"));
        jPanel2.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myUtilButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/j2meplugin/J2MEBundle").getString("run.configuration.emulator.open.utils"));
        jPanel2.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myDeviceOptionsPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

