/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.converters;

import com.intellij.hibernate.model.enums.IdUnsavedValueType;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdUnsavedValueTypeConverter
extends ResolvingConverter<IdUnsavedValueType> {
    @NotNull
    public Collection<? extends IdUnsavedValueType> getVariants(ConvertContext context) {
        IdUnsavedValueType[] unsavedValueTypes = IdUnsavedValueType.values();
        List<IdUnsavedValueType> list = Arrays.asList(unsavedValueTypes).subList(1, unsavedValueTypes.length);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/model/converters/IdUnsavedValueTypeConverter", "getVariants"));
        }
        return list;
    }

    public IdUnsavedValueType fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        IdUnsavedValueType unsavedValueType = (IdUnsavedValueType)NamedEnumUtil.getEnumElementByValue(IdUnsavedValueType.class, (String)s);
        if (unsavedValueType != null) {
            return unsavedValueType;
        }
        try {
            Long.parseLong(s);
            return IdUnsavedValueType.NUMBER;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String toString(@Nullable IdUnsavedValueType idUnsavedValueType, ConvertContext context) {
        return idUnsavedValueType == null ? null : (idUnsavedValueType == IdUnsavedValueType.NUMBER ? "0" : idUnsavedValueType.getValue());
    }

    public PsiElement resolve(IdUnsavedValueType o, ConvertContext context) {
        if (o == null) {
            String string = ((GenericValue)context.getInvocationElement()).getStringValue();
        }
        return super.resolve((Object)o, context);
    }

    public Set<String> getAdditionalVariants() {
        return new HashSet<String>(Arrays.asList("0", "-1"));
    }
}

