/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.util;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.hibernate.facet.HibernateVersion;
import com.intellij.hibernate.model.xml.config.Mapping;
import com.intellij.hibernate.model.xml.config.Property;
import com.intellij.hibernate.model.xml.config.SessionFactory;
import com.intellij.hibernate.model.xml.mapping.HbmAttributeVisitorAdapter;
import com.intellij.hibernate.model.xml.mapping.HbmClass;
import com.intellij.hibernate.model.xml.mapping.HbmClassBase;
import com.intellij.hibernate.model.xml.mapping.HbmCompositeId;
import com.intellij.hibernate.model.xml.mapping.HbmEmbeddedAttributeBase;
import com.intellij.hibernate.model.xml.mapping.HbmHibernateMapping;
import com.intellij.hibernate.model.xml.mapping.HbmJoinedSubclass;
import com.intellij.hibernate.model.xml.mapping.HbmSubclass;
import com.intellij.hibernate.model.xml.mapping.HbmUnionSubclass;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateUtil {
    private static List<Pair<HibernateVersion, String>> detectionClasses = Arrays.asList(Pair.create((Object)((Object)HibernateVersion.Hibernate_5_X), (Object)"org.hibernate.engine.FetchStrategy"), Pair.create((Object)((Object)HibernateVersion.Hibernate_4_X), (Object)"org.hibernate.engine.FetchStyle"), Pair.create((Object)((Object)HibernateVersion.Hibernate_3_X), (Object)"org.hibernate.engine.SessionFactoryImplementor"));

    private HibernateUtil() {
    }

    @NotNull
    public static HibernateVersion getHibernateVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/hibernate/util/HibernateUtil", "getHibernateVersion"));
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (Pair<HibernateVersion, String> pair : detectionClasses) {
            if (facade.findClass((String)pair.second, scope) == null) continue;
            HibernateVersion hibernateVersion = (HibernateVersion)((Object)pair.first);
            if (hibernateVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/util/HibernateUtil", "getHibernateVersion"));
            }
            return hibernateVersion;
        }
        HibernateVersion hibernateVersion = HibernateVersion.Hibernate_3_X;
        if (hibernateVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/util/HibernateUtil", "getHibernateVersion"));
        }
        return hibernateVersion;
    }

    public static String getFullPropertyName(String hibernateProperty) {
        return hibernateProperty.startsWith("hibernate.") ? hibernateProperty : "hibernate." + hibernateProperty;
    }

    public static boolean isHibernateConfig(XmlFile file) {
        String ns = JavaeeUtil.getRootTagNS((PsiFile)file, (String)"hibernate-configuration");
        if (ns == null) {
            return false;
        }
        if (ns.length() == 0) {
            return true;
        }
        if (ns.endsWith("/hibernate-configuration-3.0.dtd")) {
            return true;
        }
        return ns.equals("http://www.hibernate.org/xsd/hibernate-configuration");
    }

    public static boolean isHibernateMapping(XmlFile file) {
        String ns = JavaeeUtil.getRootTagNS((PsiFile)file, (String)"hibernate-mapping");
        if (ns == null) {
            return false;
        }
        if (ns.length() == 0) {
            return true;
        }
        if (ns.endsWith("/hibernate-mapping-3.0.dtd")) {
            return true;
        }
        return ns.equals("http://www.hibernate.org/xsd/hibernate-mapping");
    }

    public static <V, T extends Collection<V>> T getDomMappings(SessionFactory sessionFactory, final Class<V> mappingClass, final T result) {
        for (Mapping mapping : sessionFactory.getMappings()) {
            PsiFile psiFile = (PsiFile)mapping.getResource().getValue();
            if (psiFile != null || (psiFile = (PsiFile)mapping.getFile().getValue()) != null) {
                ContainerUtil.addIfNotNull((Object)JamCommonUtil.getRootElement((PsiFile)psiFile, mappingClass, (Module)sessionFactory.getModule()), result);
                continue;
            }
            psiFile = (PsiFile)mapping.getJar().getValue();
            if (psiFile == null) continue;
            final PsiManager psiManager = psiFile.getManager();
            final Module module = sessionFactory.getModule();
            HibernateUtil.processFilesInJar(psiFile.getVirtualFile(), new Processor<VirtualFile>(){

                public boolean process(VirtualFile virtualFile) {
                    PsiFile aFile = psiManager.findFile(virtualFile);
                    ContainerUtil.addIfNotNull((Object)JamCommonUtil.getRootElement((PsiFile)aFile, (Class)mappingClass, (Module)module), (Collection)result);
                    return true;
                }
            });
        }
        return result;
    }

    private static void processFilesInJar(VirtualFile virtualFile, Processor<VirtualFile> processor) {
        VirtualFile jarFile = JarFileSystem.getInstance().findFileByPath(virtualFile.getPath() + "!/");
        if (jarFile != null) {
            class Visitor {
                final /* synthetic */ Processor val$processor;

                Visitor(Processor processor) {
                    this.val$processor = processor;
                }

                boolean accept(VirtualFile file) {
                    if (file.isDirectory()) {
                        for (VirtualFile child : file.getChildren()) {
                            if (this.accept(child)) continue;
                            return false;
                        }
                    } else {
                        return this.val$processor.process((Object)file);
                    }
                    return true;
                }
            }
            new Visitor(processor).accept(jarFile);
        }
    }

    public static void consumePersistentObjects(HbmHibernateMapping mappings, final Consumer<? super HbmClassBase> classConsumer, final Consumer<? super HbmEmbeddedAttributeBase> componentConsumer) {
        final HbmAttributeVisitorAdapter componentVisitor = new HbmAttributeVisitorAdapter(){

            @Override
            public void visitEmbeddedAttributeBase(HbmEmbeddedAttributeBase embeddedAttributeBase) {
                componentConsumer.consume((Object)embeddedAttributeBase);
                embeddedAttributeBase.visitAttributes(this);
            }
        };
        Consumer<HbmClassBase> consumer = new Consumer<HbmClassBase>(){

            public void consume(HbmClassBase hbmClassBase) {
                if (classConsumer != null) {
                    classConsumer.consume((Object)hbmClassBase);
                }
                if (componentConsumer != null) {
                    hbmClassBase.visitAttributes(componentVisitor);
                }
            }
        };
        Processor<HbmSubclass> subclassProcessor = new Processor<HbmSubclass>((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public boolean process(HbmSubclass hbmSubclass) {
                this.val$consumer.consume((Object)hbmSubclass);
                ContainerUtil.process(hbmSubclass.getSubclasses(), (Processor)this);
                return true;
            }
        };
        Processor<HbmUnionSubclass> unionSubclassProcessor = new Processor<HbmUnionSubclass>((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public boolean process(HbmUnionSubclass hbmSubclass) {
                this.val$consumer.consume((Object)hbmSubclass);
                ContainerUtil.process(hbmSubclass.getUnionSubclasses(), (Processor)this);
                return true;
            }
        };
        Processor<HbmJoinedSubclass> joinedSubclassProcessor = new Processor<HbmJoinedSubclass>((Consumer)consumer){
            final /* synthetic */ Consumer val$consumer;
            {
                this.val$consumer = consumer;
            }

            public boolean process(HbmJoinedSubclass hbmSubclass) {
                this.val$consumer.consume((Object)hbmSubclass);
                ContainerUtil.process(hbmSubclass.getJoinedSubclasses(), (Processor)this);
                return true;
            }
        };
        Processor<HbmClass> classProcessor = new Processor<HbmClass>((Consumer)consumer, (Processor)subclassProcessor, (Processor)joinedSubclassProcessor, (Processor)unionSubclassProcessor){
            final /* synthetic */ Consumer val$consumer;
            final /* synthetic */ Processor val$subclassProcessor;
            final /* synthetic */ Processor val$joinedSubclassProcessor;
            final /* synthetic */ Processor val$unionSubclassProcessor;
            {
                this.val$consumer = consumer;
                this.val$subclassProcessor = processor;
                this.val$joinedSubclassProcessor = processor2;
                this.val$unionSubclassProcessor = processor3;
            }

            public boolean process(HbmClass hbmClass) {
                this.val$consumer.consume((Object)hbmClass);
                ContainerUtil.process(hbmClass.getSubclasses(), (Processor)this.val$subclassProcessor);
                ContainerUtil.process(hbmClass.getJoinedSubclasses(), (Processor)this.val$joinedSubclassProcessor);
                ContainerUtil.process(hbmClass.getUnionSubclasses(), (Processor)this.val$unionSubclassProcessor);
                return true;
            }
        };
        ContainerUtil.process(mappings.getClasses(), (Processor)classProcessor);
        ContainerUtil.process(mappings.getJoinedSubclasses(), (Processor)joinedSubclassProcessor);
        ContainerUtil.process(mappings.getSubclasses(), (Processor)subclassProcessor);
        ContainerUtil.process(mappings.getUnionSubclasses(), (Processor)unionSubclassProcessor);
    }

    public static boolean isEmbedded(HbmCompositeId compositeId) {
        return StringUtil.isNotEmpty((String)compositeId.getClazz().getStringValue()) && !Boolean.TRUE.equals(compositeId.getMapped().getValue());
    }

    @Nullable
    public static String getPropertyShortName(String name) {
        return name != null && name.startsWith("hibernate.") ? name.substring("hibernate.".length()) : name;
    }

    @Nullable
    public static Property<Object> findSessionFactoryProperty(SessionFactory factory, String propertyName) {
        String propertyShortName = HibernateUtil.getPropertyShortName(propertyName);
        for (Property<Object> property : factory.getProperties()) {
            String name = (String)property.getName().getValue();
            String shortName = HibernateUtil.getPropertyShortName(name);
            if (!StringUtil.isNotEmpty((String)shortName) || !Comparing.strEqual((String)propertyShortName, (String)shortName)) continue;
            return property;
        }
        return null;
    }

    public static Property<Object> setSessionFactoryProperty(SessionFactory factory, String propertyName, String value) {
        Property<Object> property;
        Property<Object> existingProperty = HibernateUtil.findSessionFactoryProperty(factory, propertyName);
        Property<Object> property2 = property = existingProperty == null ? factory.addProperty() : existingProperty;
        if (existingProperty == null) {
            property.getName().setStringValue(propertyName);
        }
        property.setStringValue(value);
        return property;
    }

    public static String getDefaultDialectValue(PsiElement element, String jdbcUrl) {
        StringTokenizer st = new StringTokenizer(jdbcUrl, ":");
        if (!st.hasMoreTokens()) {
            return "";
        }
        st.nextToken();
        if (!st.hasMoreTokens()) {
            return "";
        }
        String token = st.nextToken().toLowerCase();
        ArrayList<String> dialects = new ArrayList<String>();
        for (PsiReference reference : element.getReferences()) {
            Object[] variants;
            for (Object variant : variants = reference.getVariants()) {
                String variantStr;
                Object obj = variant instanceof LookupElement ? ((LookupElement)variant).getObject() : null;
                String string = variantStr = obj instanceof PsiClass ? ((PsiClass)obj).getQualifiedName() : null;
                if (variantStr == null || !variantStr.toLowerCase().contains(token)) continue;
                dialects.add(variantStr);
            }
        }
        if (dialects.isEmpty()) {
            return "";
        }
        Collections.sort(dialects);
        return (String)dialects.get(0);
    }
}

