/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.emma;

import com.vladium.emma.AppLoggers;
import com.vladium.emma.EMMAProperties;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.Processor;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.CoverageOptionsFactory;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.ISessionData;
import com.vladium.emma.data.SessionData;
import com.vladium.emma.filter.IInclExclFilter;
import com.vladium.emma.rt.RT;
import com.vladium.emma.rt.RTSettings;
import com.vladium.emma.run.IClassLoadHook;
import com.vladium.emma.run.InstrClassLoadHook;
import com.vladium.logging.Logger;
import com.vladium.util.ByteArrayOStream;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.util.exit.ExitHookManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class RunnerAgent
extends Processor
implements IAppErrorCodes {
    private static final int BUF_SIZE = 32768;
    private final Instrumentation m_instrumentation;
    private static final String EMMA_CLASSES_EXCLUSION_FILTER = "-com/vladium/emma/*";
    private static final String SUN_CLASSES_EXCLUSION_FILTER = "-sun/*";
    private static final String JAVA_LANG_CLASSES_EXCLUSION_FILTER = "-java/lang/*";
    private static final String EMMA_RT_CLASS_NAME = "com/vladium/emma/IAppConstants";
    private IInclExclFilter m_coverageFilter;
    private File m_sdataOutFile;
    private Boolean m_sdataOutMerge;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        IProperties toolProperties;
        this.validateState();
        RTSettings.setStandaloneMode((boolean)false);
        RT.reset((RTSettings.SetActions)new RTSettings.SetActions(1, 1, 2, 0));
        IProperties appProperties = RT.getAppProperties();
        if (appProperties == null) {
            appProperties = EMMAProperties.getAppProperties();
        }
        if ((toolProperties = IProperties.Factory.combine((IProperties)this.m_propertyOverrides, (IProperties)appProperties)) == null) {
            throw new RuntimeException("toolProperties is null");
        }
        Logger current = Logger.getLogger();
        Logger log = AppLoggers.create((String)this.m_appName, (IProperties)toolProperties, (Logger)current);
        if (log.atTRACE1()) {
            log.trace1("run", "complete tool properties:");
            toolProperties.list(log.getWriter());
        }
        try {
            Logger.push((Logger)log);
            this.m_log = log;
            this._run(toolProperties);
        }
        finally {
            if (this.m_log != null) {
                Logger.pop((Logger)this.m_log);
                this.m_log = null;
            }
        }
    }

    public final synchronized void setInclExclFilter(String[] specs) {
        String[] finalSpecs = new String[specs.length + 3];
        System.arraycopy(specs, 0, finalSpecs, 0, specs.length);
        finalSpecs[specs.length] = EMMA_CLASSES_EXCLUSION_FILTER;
        finalSpecs[specs.length + 1] = SUN_CLASSES_EXCLUSION_FILTER;
        finalSpecs[specs.length + 2] = JAVA_LANG_CLASSES_EXCLUSION_FILTER;
        this.m_coverageFilter = IInclExclFilter.Factory.create((String[])finalSpecs);
    }

    public final synchronized void setSessionOutFile(String fileName) {
        if (fileName == null) {
            this.m_sdataOutFile = null;
        } else {
            File _file = new File(fileName);
            if (_file.exists() && !_file.isFile()) {
                throw new IllegalArgumentException("not a file: [" + _file.getAbsolutePath() + "]");
            }
            this.m_sdataOutFile = _file;
        }
    }

    public final synchronized void setSessionOutMerge(Boolean merge) {
        this.m_sdataOutMerge = merge;
    }

    public static void premain(String argsString, Instrumentation instrumentation) {
        String[] args;
        if (new File(argsString).isFile()) {
            try {
                args = RunnerAgent.readArgsFromFile(argsString);
            }
            catch (IOException e) {
                System.out.println("Invalid emma args. Coverage was not enabled.");
                return;
            }
        } else {
            args = RunnerAgent.tokenize(argsString);
        }
        RunnerAgent agent = new RunnerAgent(instrumentation);
        agent.parseArgs(args);
        agent.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] readArgsFromFile(String arg) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File file = new File(arg);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            while (reader.ready()) {
                result.add(reader.readLine());
            }
        }
        finally {
            reader.close();
        }
        return result.toArray(new String[result.size()]);
    }

    private static String[] tokenize(String argumentString) {
        ArrayList<String> tokenizedArgs = new ArrayList<String>();
        StringBuffer currentArg = new StringBuffer();
        block4: for (int i = 0; i < argumentString.length(); ++i) {
            char c = argumentString.charAt(i);
            switch (c) {
                default: {
                    currentArg.append(c);
                    continue block4;
                }
                case ' ': {
                    String arg = currentArg.toString();
                    if (arg.length() > 0) {
                        tokenizedArgs.add(arg);
                    }
                    currentArg = new StringBuffer();
                    continue block4;
                }
                case '\"': {
                    char d;
                    ++i;
                    while (i < argumentString.length() && (d = argumentString.charAt(i)) != '\"') {
                        currentArg.append(d);
                        ++i;
                    }
                    break block0;
                }
            }
        }
        String arg = currentArg.toString();
        if (arg.length() > 0) {
            tokenizedArgs.add(arg);
        }
        return tokenizedArgs.toArray(new String[tokenizedArgs.size()]);
    }

    private static String[] tokenize(String listArg, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(listArg, delimiter);
        ArrayList<String> tokenizedArgs = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            tokenizedArgs.add(tokenizer.nextToken());
        }
        return tokenizedArgs.toArray(new String[tokenizedArgs.size()]);
    }

    private void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-f".equals(arg)) {
                if (++i == args.length) {
                    RunnerAgent.showUsageString(args);
                    return;
                }
                String filter = args[i];
                String[] patterns = RunnerAgent.tokenize(filter, ",");
                this.setInclExclFilter(patterns);
                continue;
            }
            if ("-o".equals(arg)) {
                if (++i == args.length) {
                    RunnerAgent.showUsageString(args);
                    return;
                }
                this.setSessionOutFile(args[i]);
                continue;
            }
            RunnerAgent.showUsageString(args);
            return;
        }
    }

    protected void validateState() {
        super.validateState();
        if (this.m_coverageFilter == null) {
            this.m_coverageFilter = IInclExclFilter.Factory.create((String[])new String[]{EMMA_CLASSES_EXCLUSION_FILTER, SUN_CLASSES_EXCLUSION_FILTER, JAVA_LANG_CLASSES_EXCLUSION_FILTER});
        }
        if (this.m_coverageFilter.included(EMMA_RT_CLASS_NAME)) {
            throw new IllegalArgumentException("Too general Classes filter, includes emma runtime classes as well");
        }
    }

    private static void showUsageString(String[] args) {
        System.out.println("invalid emma agent options:");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            System.out.println(arg);
        }
        System.out.println("\nValid options are: -f <classes_filter> [-o <session_output_file>]");
    }

    protected void _run(IProperties toolProperties) {
        Logger log = this.m_log;
        boolean verbose = log.atVERBOSE();
        File sdataOutFile = this.m_sdataOutFile;
        Boolean sdataOutMerge = this.m_sdataOutMerge;
        if (sdataOutFile == null) {
            sdataOutFile = new File(toolProperties.getProperty("session.out.file", "coverage.es"));
        }
        if (sdataOutMerge == null) {
            String _dataOutMerge = toolProperties.getProperty("session.out.merge", EMMAProperties.DEFAULT_SESSION_DATA_OUT_MERGE.toString());
            Boolean bl = sdataOutMerge = Property.toBoolean((String)_dataOutMerge) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (verbose) {
            log.verbose("session data output file: " + sdataOutFile.getAbsolutePath());
            log.verbose("session data output merge mode: " + sdataOutMerge);
        }
        ExitHookManager runnerExitHookManager = null;
        try {
            runnerExitHookManager = ExitHookManager.getSingleton();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        ICoverageData cdata = RT.getCoverageData();
        if (cdata == null) {
            throw new RuntimeException("cdata is null");
        }
        toolProperties.setProperty("instr.exclude_synthetic_methods", "true");
        toolProperties.setProperty("instr.exclude_bridge_methods", "true");
        IMetaData mdata = DataFactory.newMetaData((CoverageOptions)CoverageOptionsFactory.create((IProperties)toolProperties));
        AppRunnerExitHook runnerExitHook = new AppRunnerExitHook(log, true, sdataOutFile, sdataOutMerge, mdata, cdata, toolProperties);
        if (runnerExitHookManager != null) {
            runnerExitHookManager.addExitHook((Runnable)runnerExitHook);
        }
        final LimitedPool pool = new LimitedPool(10);
        InstrClassLoadHook hook = new InstrClassLoadHook(this.m_coverageFilter, mdata);
        this.m_instrumentation.addTransformer(new ClassFileTransformer((IClassLoadHook)hook){
            final /* synthetic */ IClassLoadHook val$hook;
            {
                this.val$hook = iClassLoadHook;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                ByteArrayOStream baos = pool.alloc();
                try {
                    if (!this.val$hook.processClassDef(className, classfileBuffer, classfileBuffer.length, baos)) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    byte[] byArray = baos.copyByteArray();
                    return byArray;
                }
                catch (IOException e) {
                    byte[] byArray = null;
                    return byArray;
                }
                finally {
                    pool.recycle(baos);
                }
            }
        });
    }

    private RunnerAgent(Instrumentation instrumentation) {
        this.m_instrumentation = instrumentation;
    }

    private static final class AppRunnerExitHook
    implements Runnable {
        private final Logger m_log;
        private final boolean m_dumpRawData;
        private final File m_sdataOutFile;
        private final boolean m_sdataOutMerge;
        private IMetaData m_mdata;
        private ICoverageData m_cdata;
        private IProperties m_properties;
        private boolean m_done;
        private Throwable m_dataDumpFailure;
        private List m_reportFailures;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            block9: {
                try {
                    if (this.m_done) break block9;
                    IMetaData mdataSnashot = this.m_mdata.shallowCopy();
                    this.m_mdata = null;
                    ICoverageData cdataSnapshot = this.m_cdata.shallowCopy();
                    this.m_cdata = null;
                    if (mdataSnashot.isEmpty()) {
                        this.m_log.warning("no metadata collected at runtime [no reports generated]");
                        return;
                    }
                    if (cdataSnapshot.isEmpty()) {
                        this.m_log.warning("no coverage data collected at runtime [all reports will be empty]");
                    }
                    SessionData sdata = new SessionData(mdataSnashot, cdataSnapshot);
                    if (!this.m_dumpRawData || this.m_sdataOutFile == null) break block9;
                    try {
                        boolean info = this.m_log.atINFO();
                        long start = info ? System.currentTimeMillis() : 0L;
                        DataFactory.persist((ISessionData)sdata, (File)this.m_sdataOutFile, (boolean)this.m_sdataOutMerge);
                        if (info) {
                            long end = System.currentTimeMillis();
                            this.m_log.info("raw session data saved to [" + this.m_sdataOutFile.getAbsolutePath() + "] {in " + (end - start) + " ms}");
                        }
                    }
                    catch (Throwable t) {
                        this.m_dataDumpFailure = t;
                    }
                }
                finally {
                    this.m_mdata = null;
                    this.m_cdata = null;
                    this.m_properties = null;
                    this.m_done = true;
                }
            }
        }

        AppRunnerExitHook(Logger log, boolean dumpRawData, File sdataOutFile, boolean sdataOutMerge, IMetaData mdata, ICoverageData cdata, IProperties properties) {
            if (log == null) {
                throw new IllegalArgumentException("null input: log");
            }
            if (mdata == null) {
                throw new IllegalArgumentException("null input: mdata");
            }
            if (cdata == null) {
                throw new IllegalArgumentException("null input: cdata");
            }
            if (properties == null) {
                throw new IllegalArgumentException("null input: properties");
            }
            this.m_log = log;
            this.m_dumpRawData = dumpRawData;
            this.m_sdataOutFile = sdataOutFile;
            this.m_sdataOutMerge = sdataOutMerge;
            this.m_mdata = mdata;
            this.m_cdata = cdata;
            this.m_properties = properties;
        }

        synchronized Throwable getDataDumpFailure() {
            return this.m_dataDumpFailure;
        }

        synchronized List getReportFailures() {
            return this.m_reportFailures;
        }
    }

    public static class LimitedPool {
        private final int capacity;
        private final ByteArrayOStream[] storage;
        private int index = 0;

        public LimitedPool(int capacity) {
            this.capacity = capacity;
            this.storage = new ByteArrayOStream[capacity];
        }

        public synchronized ByteArrayOStream alloc() {
            if (this.index == 0) {
                return new ByteArrayOStream(32768);
            }
            return this.storage[--this.index];
        }

        public synchronized void recycle(ByteArrayOStream t) {
            t.reset();
            if (this.index >= this.capacity) {
                return;
            }
            this.storage[this.index++] = t;
        }
    }
}

