/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.javascript.debugger.nashorn.NashornDebuggerSupportWrapper;
import com.intellij.javascript.debugger.nashorn.NashornObject;
import com.intellij.util.Consumer;
import com.jetbrains.debugger.jdi.AsyncResultCommand;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.values.ArrayValue;
import org.jetbrains.debugger.values.IndexedVariablesConsumer;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

final class NashornArray
extends NashornObject
implements ArrayValue {
    private static final PromiseManager<NashornArray, List<Variable>> INDEXED_VARIABLES_LOADER = new PromiseManager<NashornArray, List<Variable>>(NashornArray.class){

        public boolean isUpToDate(@NotNull NashornArray host, @NotNull List<Variable> data) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/javascript/debugger/nashorn/NashornArray$1", "isUpToDate"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/javascript/debugger/nashorn/NashornArray$1", "isUpToDate"));
            }
            return ((JdiValueManager)host.getChildrenManager().valueManager).getCacheStamp() == host.indexedVariableCacheStamp;
        }

        @NotNull
        public Promise<List<Variable>> load(@NotNull NashornArray host) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/javascript/debugger/nashorn/NashornArray$1", "load"));
            }
            AsyncPromise asyncPromise = host.loadIndexedVariables();
            if (asyncPromise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornArray$1", "load"));
            }
            return asyncPromise;
        }
    };
    private volatile Promise<List<? extends Variable>> indexedVariables;
    private volatile int indexedVariableCacheStamp;
    private final int length;

    public NashornArray(int length, @NotNull ObjectReference objectReference, @Nullable String valueString, @NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager) {
        if (objectReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/intellij/javascript/debugger/nashorn/NashornArray", "<init>"));
        }
        if (threadReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadReference", "com/intellij/javascript/debugger/nashorn/NashornArray", "<init>"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/intellij/javascript/debugger/nashorn/NashornArray", "<init>"));
        }
        super(ValueType.ARRAY, objectReference, valueString, threadReference, valueManager);
        this.indexedVariableCacheStamp = -1;
        this.length = length;
    }

    public int getLength() {
        return this.length;
    }

    @NotNull
    public Promise<Void> getIndexedProperties(int from, int to, int bucketThreshold, final @NotNull IndexedVariablesConsumer consumer, @Nullable ValueType componentType) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/javascript/debugger/nashorn/NashornArray", "getIndexedProperties"));
        }
        Promise result = INDEXED_VARIABLES_LOADER.get((Object)this);
        Promise promise = result.done((Consumer)new Consumer<List<Variable>>(){

            public void consume(List<Variable> variables) {
                if (!consumer.isObsolete()) {
                    consumer.consumeVariables(variables);
                }
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornArray", "getIndexedProperties"));
        }
        return promise;
    }

    @NotNull
    private AsyncPromise<List<Variable>> loadIndexedVariables() {
        AsyncPromise promise = new AsyncPromise();
        ((JdiValueManager)this.getChildrenManager().valueManager).getManagerThread().schedule((DebuggerCommandImpl)new AsyncResultCommand<List<Variable>>(promise){

            @Override
            protected void doAction() throws Exception {
                NashornDebuggerSupportWrapper debuggerSupport = NashornDebuggerSupportWrapper.get(NashornArray.this.threadReference, (JdiValueManager)NashornArray.this.getChildrenManager().valueManager);
                ArrayReference values = debuggerSupport.getIndexedValues(NashornArray.this.objectReference, NashornArray.this.threadReference, 0, NashornArray.this.length);
                int loadedLength = values.length();
                if (loadedLength == 0) {
                    NashornArray.this.indexedVariableCacheStamp = ((JdiValueManager)NashornArray.this.getChildrenManager().valueManager).getCacheStamp();
                    this.promise.setResult(Collections.emptyList());
                    return;
                }
                Variable[] variables = new Variable[loadedLength];
                List<com.sun.jdi.Value> valueDescriptors = values.getValues();
                int size = valueDescriptors.size();
                for (int i = 0; i < size; ++i) {
                    ObjectReference valueDescriptor = (ObjectReference)valueDescriptors.get(i);
                    Map<Field, com.sun.jdi.Value> fieldToValue = debuggerSupport.getValues(valueDescriptor);
                    Value value = NashornObject.createValue(NashornArray.this.threadReference, (JdiValueManager)NashornArray.this.getChildrenManager().valueManager, debuggerSupport, fieldToValue);
                    variables[i] = new VariableImpl(Integer.toString(debuggerSupport.getIndex(fieldToValue)), value, null);
                }
                NashornArray.this.indexedVariableCacheStamp = ((JdiValueManager)NashornArray.this.getChildrenManager().valueManager).getCacheStamp();
                this.promise.setResult(Arrays.asList(variables));
            }
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornArray", "loadIndexedVariables"));
        }
        return asyncPromise;
    }
}

