/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.PositionManagerFactory;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.PositionManagerEx;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.javascript.debugger.nashorn.NashornArray;
import com.intellij.javascript.debugger.nashorn.NashornCallFrame;
import com.intellij.javascript.debugger.nashorn.NashornCallFrameEvaluateContextKt;
import com.intellij.javascript.debugger.nashorn.NashornObject;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueNode;
import com.jetbrains.debugger.jdi.JavaDebuggerViewSupport;
import com.jetbrains.debugger.jdi.JdiSuspendContext;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerEvaluator;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.io.LocalFileFinder;

public class NashornPositionManagerFactory
extends PositionManagerFactory {
    static final Logger LOG = Logger.getInstance(NashornPositionManagerFactory.class);
    private static final JavaDebuggerViewSupport DEBUGGER_VIEW_SUPPORT = new JavaDebuggerViewSupport(){

        @Override
        public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeObjectPresentation"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeObjectPresentation"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeObjectPresentation"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeObjectPresentation"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeObjectPresentation"));
            }
            if (value instanceof NashornObject) {
                VariableView.Companion.setObjectPresentation(value, icon, node);
            } else {
                super.computeObjectPresentation(value, variable, context, node, icon);
            }
        }

        @Override
        public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeArrayPresentation"));
            }
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeArrayPresentation"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeArrayPresentation"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeArrayPresentation"));
            }
            if (icon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "computeArrayPresentation"));
            }
            if (value instanceof NashornArray) {
                VariableView.Companion.setArrayPresentation(value, context, icon, node);
            } else {
                super.computeArrayPresentation(value, variable, context, node, icon);
            }
        }

        @NotNull
        public XDebuggerEvaluator createFrameEvaluator(@NotNull CallFrameView frameView) {
            if (frameView == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameView", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "createFrameEvaluator"));
            }
            JavaScriptDebuggerEvaluator javaScriptDebuggerEvaluator = new JavaScriptDebuggerEvaluator((VariableContext)frameView);
            if (javaScriptDebuggerEvaluator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$1", "createFrameEvaluator"));
            }
            return javaScriptDebuggerEvaluator;
        }
    };

    public static boolean isNashornApplicable(@NotNull SourcePosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory", "isNashornApplicable"));
        }
        return position.getFile() instanceof JSFile;
    }

    @Nullable
    public PositionManager createPositionManager(@NotNull DebugProcess process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory", "createPositionManager"));
        }
        return new NashornPositionManager(process);
    }

    private static class NashornPositionManager
    extends PositionManagerEx {
        private static final String NASHORN_SCRIPT_FQN = "jdk.nashorn.internal.scripts.Script";
        private static final String NASHORN_SCRIPT_PREFIX = "jdk.nashorn.internal.scripts.Script$";
        private static final String NASHORN_SCRIPT_NAME_PATTERN = "jdk.nashorn.internal.scripts.Script$*";
        private final DebugProcess debugProcess;
        private final Map<VirtualFile, ReferenceType> mapping;
        private JdiSuspendContext suspendContext;

        public NashornPositionManager(@NotNull DebugProcess debugProcess) {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "<init>"));
            }
            this.mapping = new THashMap();
            this.debugProcess = debugProcess;
            this.debugProcess.addDebugProcessListener((DebugProcessListener)new DebugProcessAdapter(){

                public void processDetached(DebugProcess process, boolean closedByUser) {
                    NashornPositionManager.this.suspendContext = null;
                }

                public void resumed(SuspendContext javaSuspendContext) {
                    NashornPositionManager.this.suspendContext = null;
                }
            });
        }

        private static void checkJsFile(@NotNull SourcePosition position) throws NoDataException {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "checkJsFile"));
            }
            if (!NashornPositionManagerFactory.isNashornApplicable(position)) {
                throw NoDataException.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private VirtualFile getVirtualFile(@NotNull Location location) {
            Module module;
            String vmPath;
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "getVirtualFile"));
            }
            try {
                vmPath = NashornPositionManager.getNormalizedVmPath(location.declaringType());
            }
            catch (AbsentInformationException ignored) {
                return null;
            }
            if (vmPath == null) {
                return null;
            }
            VirtualFile file = null;
            GlobalSearchScope searchScope = this.debugProcess.getSearchScope();
            if (searchScope instanceof ModuleWithDependenciesScope && (file = NashornPositionManager.getSourceFileByOutput(vmPath, module = ((ModuleWithDependenciesScope)searchScope).getModule(), null)) == null) {
                AccessToken token = ReadAction.start();
                try {
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                    file = NashornPositionManager.findFileByRelativePath(vmPath, moduleRootManager.getSourceRoots());
                    if (file == null) {
                        file = NashornPositionManager.findFileByRelativePath(vmPath, moduleRootManager.getContentRoots());
                    }
                }
                finally {
                    token.finish();
                }
            }
            if (file == null && (file = this.debugProcess.getProject().getBaseDir().findFileByRelativePath(vmPath)) == null) {
                return LocalFileFinder.findFile((String)vmPath);
            }
            return file;
        }

        @Nullable
        private static VirtualFile findFileByRelativePath(@NotNull String path, @NotNull VirtualFile[] roots) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "findFileByRelativePath"));
            }
            if (roots == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "findFileByRelativePath"));
            }
            for (VirtualFile root : roots) {
                VirtualFile file = root.findFileByRelativePath(path);
                if (file == null) continue;
                return file;
            }
            return null;
        }

        @Nullable
        private static String getNormalizedVmPath(@NotNull ReferenceType referenceType) throws AbsentInformationException {
            if (referenceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceType", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "getNormalizedVmPath"));
            }
            String name = StringUtil.nullize((String)referenceType.sourceName());
            return name == null ? null : FileUtil.toCanonicalPath((String)FileUtil.toSystemIndependentName((String)name), (char)'/');
        }

        @Nullable
        public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl jdiFrame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location) {
            if (jdiFrame == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdiFrame", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "createStackFrame"));
            }
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "createStackFrame"));
            }
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "createStackFrame"));
            }
            if (!NashornPositionManager.isNashornScriptLocation(location)) {
                return null;
            }
            SourceInfo sourceInfo = SourceInfo.create(null, (VirtualFile)this.getVirtualFile(location), (int)(location.lineNumber() - 1), (int)-1);
            if (sourceInfo == null) {
                return null;
            }
            NashornCallFrame frame = new NashornCallFrame((JdiValueManager)this.getOrCreateSuspendManager(debugProcess).getValueManager(), jdiFrame, sourceInfo.getLine(), sourceInfo.getColumn());
            return new CallFrameView((CallFrame)frame, (DebuggerViewSupport)DEBUGGER_VIEW_SUPPORT, null, sourceInfo);
        }

        private static boolean isNashornScriptLocation(@NotNull Location location) {
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "isNashornScriptLocation"));
            }
            return location.declaringType().name().startsWith(NASHORN_SCRIPT_PREFIX);
        }

        @NotNull
        private JdiSuspendContext getOrCreateSuspendManager(@NotNull DebugProcessImpl debugProcess) {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "getOrCreateSuspendManager"));
            }
            if (this.suspendContext == null) {
                this.suspendContext = new JdiSuspendContext(debugProcess, true);
            }
            JdiSuspendContext jdiSuspendContext = this.suspendContext;
            if (jdiSuspendContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "getOrCreateSuspendManager"));
            }
            return jdiSuspendContext;
        }

        public ThreeState evaluateCondition(@NotNull EvaluationContext context, @NotNull StackFrameProxyImpl frame, @NotNull Location location, @NotNull String expression) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "evaluateCondition"));
            }
            if (frame == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frame", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "evaluateCondition"));
            }
            if (location == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "evaluateCondition"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "evaluateCondition"));
            }
            if (!NashornPositionManager.isNashornScriptLocation(location)) {
                return ThreeState.UNSURE;
            }
            DebuggerManagerThreadImpl.assertIsManagerThread();
            try {
                com.sun.jdi.Value jdiValue = frame.visibleValueByName(expression);
                if (jdiValue != null) {
                    if (jdiValue instanceof BooleanValue) {
                        return ((BooleanValue)jdiValue).booleanValue() ? ThreeState.YES : ThreeState.NO;
                    }
                    return ThreeState.UNSURE;
                }
                Value value = NashornCallFrameEvaluateContextKt.doEvaluate(expression, frame, (JdiValueManager)this.getOrCreateSuspendManager((DebugProcessImpl)context.getDebugProcess()).getValueManager(), context);
                if (value.getType() == ValueType.BOOLEAN) {
                    return "true".equals(value.getValueString()) ? ThreeState.YES : ThreeState.NO;
                }
                return ThreeState.UNSURE;
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
                return ThreeState.UNSURE;
            }
        }

        @Nullable
        public SourcePosition getSourcePosition(@Nullable Location location) throws NoDataException {
            PsiFile psiFile;
            if (location == null || !NashornPositionManager.isNashornScriptLocation(location)) {
                throw NoDataException.INSTANCE;
            }
            VirtualFile virtualFile = this.getVirtualFile(location);
            if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)this.debugProcess.getProject()).findFile(virtualFile)) != null) {
                return SourcePosition.createFromLine((PsiFile)psiFile, (int)(location.lineNumber() - 1));
            }
            throw NoDataException.INSTANCE;
        }

        @NotNull
        public List<ReferenceType> getAllClasses(@NotNull SourcePosition classPosition) throws NoDataException {
            if (classPosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classPosition", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "getAllClasses"));
            }
            NashornPositionManager.checkJsFile(classPosition);
            ReferenceType type = this.mapping.get(classPosition.getFile().getVirtualFile());
            if (type == null) {
                throw NoDataException.INSTANCE;
            }
            List<ReferenceType> list = Collections.singletonList(type);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "getAllClasses"));
            }
            return list;
        }

        @NotNull
        public List<Location> locationsOfLine(@NotNull ReferenceType type, @NotNull SourcePosition position) throws NoDataException {
            List<Location> list;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "locationsOfLine"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "locationsOfLine"));
            }
            NashornPositionManager.checkJsFile(position);
            try {
                list = type.locationsOfLine("Java", null, position.getLine() + 1);
            }
            catch (AbsentInformationException absentInformationException) {
                List<Location> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "locationsOfLine"));
                }
                return list2;
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "locationsOfLine"));
            }
            return list;
        }

        private boolean isInOutput(@NotNull String vmPath, @Nullable VirtualFile sourceRootForFile) {
            if (vmPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmPath", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "isInOutput"));
            }
            GlobalSearchScope searchScope = this.debugProcess.getSearchScope();
            if (!(searchScope instanceof ModuleWithDependenciesScope)) {
                return false;
            }
            return NashornPositionManager.getSourceFileByOutput(vmPath, ((ModuleWithDependenciesScope)searchScope).getModule(), sourceRootForFile) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private static VirtualFile getSourceFileByOutput(@NotNull String vmPath, @NotNull Module module, @Nullable VirtualFile sourceRootForFile) {
            if (vmPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmPath", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "getSourceFileByOutput"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "getSourceFileByOutput"));
            }
            CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
            if (compilerModuleExtension == null) {
                return null;
            }
            AccessToken token = ReadAction.start();
            try {
                VirtualFile[] sourceRoots = null;
                for (VirtualFile outputRoot : compilerModuleExtension.getOutputRoots(true)) {
                    String outputRootPath = outputRoot.getPath();
                    String relativePath = FileUtilRt.getRelativePath((String)outputRootPath, (String)vmPath, (char)'/');
                    if (relativePath == null) continue;
                    if (sourceRootForFile != null) {
                        VirtualFile file = sourceRootForFile.findFileByRelativePath(relativePath);
                        if (file == null) continue;
                        VirtualFile virtualFile = file;
                        return virtualFile;
                    }
                    if (sourceRoots == null) {
                        sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                    }
                    for (VirtualFile sourceRoot : sourceRoots) {
                        VirtualFile file = sourceRoot.findFileByRelativePath(relativePath);
                        if (file == null) continue;
                        VirtualFile virtualFile = file;
                        return virtualFile;
                    }
                }
            }
            finally {
                token.finish();
            }
            return null;
        }

        @Nullable
        public ClassPrepareRequest createPrepareRequest(final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position) throws NoDataException {
            if (requestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "createPrepareRequest"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager", "createPrepareRequest"));
            }
            NashornPositionManager.checkJsFile(position);
            return this.debugProcess.getRequestsManager().createClassPrepareRequest(new ClassPrepareRequestor(){

                public void processClassPrepare(@NotNull DebugProcess debuggerProcess, @NotNull ReferenceType referenceType) {
                    String vmPath;
                    if (debuggerProcess == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerProcess", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager$2", "processClassPrepare"));
                    }
                    if (referenceType == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceType", "com/intellij/javascript/debugger/nashorn/NashornPositionManagerFactory$NashornPositionManager$2", "processClassPrepare"));
                    }
                    try {
                        vmPath = NashornPositionManager.getNormalizedVmPath(referenceType);
                    }
                    catch (AbsentInformationException ignored) {
                        return;
                    }
                    if (vmPath != null && !vmPath.equals("<eval>") && !vmPath.startsWith("nashorn:")) {
                        VirtualFile positionFile = position.getFile().getVirtualFile();
                        VirtualFile sourceRootForFile = ProjectFileIndex.SERVICE.getInstance((Project)debuggerProcess.getProject()).getSourceRootForFile(positionFile);
                        if (!NashornPositionManager.this.isInOutput(vmPath, sourceRootForFile)) {
                            String path = positionFile.getPath();
                            if (!(!SystemInfo.isFileSystemCaseSensitive ? StringUtilRt.endsWithIgnoreCase((CharSequence)path, (CharSequence)vmPath) : path.endsWith(vmPath))) {
                                return;
                            }
                        }
                        NashornPositionManager.this.mapping.put(positionFile, referenceType);
                        requestor.processClassPrepare(debuggerProcess, referenceType);
                    }
                }
            }, NASHORN_SCRIPT_NAME_PATTERN);
        }
    }
}

