/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.custom;

import com.intellij.spring.model.xml.custom.CustomBeanParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

class MyBeanDefinitionsRegistry
extends DefaultListableBeanFactory
implements ResourceLoader,
ResourcePatternResolver {
    private final List myResult = new ArrayList();
    private final ResourceLoader myDelegate = new DefaultResourceLoader(((Object)((Object)this)).getClass().getClassLoader());
    private final ResourcePatternResolver myResourcePatternResolver = new PathMatchingResourcePatternResolver(((Object)((Object)this)).getClass().getClassLoader());

    MyBeanDefinitionsRegistry() {
        this.myResult.add("no_infrastructures");
    }

    public List getResult() {
        return this.myResult;
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeanDefinitionStoreException {
        Object source;
        super.registerBeanDefinition(beanName, beanDefinition);
        if (beanDefinition.getRole() == 2) {
            this.myResult.set(0, "has_infrastructures");
            return;
        }
        ArrayList<String> info = new ArrayList<String>();
        MyBeanDefinitionsRegistry.appendTag(info, beanName, "beanName");
        MyBeanDefinitionsRegistry.appendTag(info, beanDefinition.getBeanClassName(), "beanClassName");
        info.add("constructorArgumentCount");
        info.add(String.valueOf(beanDefinition.getConstructorArgumentValues().getArgumentCount()));
        if (beanDefinition instanceof AbstractBeanDefinition) {
            AbstractBeanDefinition definition = (AbstractBeanDefinition)beanDefinition;
            MyBeanDefinitionsRegistry.appendTag(info, definition.getFactoryMethodName(), "factoryMethodName");
            MyBeanDefinitionsRegistry.appendTag(info, definition.getFactoryBeanName(), "factoryBeanName");
        }
        if ((source = beanDefinition.getSource()) instanceof int[]) {
            info.add("path");
            StringBuilder path = new StringBuilder("x");
            int[] ints = (int[])source;
            for (int i = 0; i < ints.length; ++i) {
                if (i > 0) {
                    path.append(";");
                }
                path.append(ints[i]);
            }
            info.add(path.toString());
        }
        this.myResult.add(info);
    }

    private static void appendTag(List info, String value, String tagName) {
        if (value == null) {
            return;
        }
        info.add(tagName);
        info.add(CustomBeanParser.encode(value));
    }

    public ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public Resource getResource(String location) {
        return this.myDelegate.getResource(location);
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        return this.myResourcePatternResolver.getResources(locationPattern);
    }
}

