/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import com.android.tools.idea.editors.gfxtrace.controllers.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.controllers.ImageFetcher;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.ScrubberLabelData;
import com.android.tools.idea.editors.gfxtrace.renderers.ScrubberLabel;
import com.android.tools.idea.editors.gfxtrace.renderers.styles.RoundedLineBorder;
import com.android.tools.idea.editors.gfxtrace.rpc.RenderSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class ScrubberCellRenderer
implements ListCellRenderer {
    private static final int MAX_CACHE_SIZE = 45;
    private static final int BORDER_SIZE = 5;
    private static final int MIN_WIDTH = 64;
    private static final int MIN_HEIGHT = 64;
    private static final int MAX_WIDTH = 192;
    private static final int MAX_HEIGHT = 192;
    @NotNull
    private static final Border DEFAULT_BORDER = new EmptyBorder(5, 5, 5, 5);
    @NotNull
    private static final Border SELECTED_BORDER = new RoundedLineBorder(UIUtil.getFocusedBoundsColor(), 5, false);
    @NotNull
    private static final Dimension DEFAULT_IMAGE_SIZE = new Dimension(192, 192);
    @NotNull
    private static final ScheduledExecutorService ourScheduler = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"ScrubberAnimation");
    @NotNull
    private final ScrubberLabel myScrubberLabel;
    @NotNull
    private RenderSettings myRenderSettings;
    @NotNull
    private Set<Integer> myOutstandingIconFetches;
    @NotNull
    private HashMap<Integer, ImageIcon> myCachedImages;
    @NotNull
    private ImageIcon myBlankIcon;
    @NotNull
    private AtomicBoolean shouldStop = new AtomicBoolean(false);
    @NotNull
    private List<Integer> myPostRenderCleanupCacheHits = new ArrayList<Integer>(20);
    private ScheduledFuture<?> myTicker;
    private Dimension myLargestKnownIconDimension = new Dimension(64, 64);
    private int myRepaintsNeeded;
    @NotNull
    private List<DimensionChangeListener> myDimensionChangeListeners = new ArrayList<DimensionChangeListener>(1);
    private ImageFetcher myImageFetcher;

    public ScrubberCellRenderer() {
        this.myScrubberLabel = new ScrubberLabel();
        this.myOutstandingIconFetches = new HashSet();
        this.myCachedImages = new HashMap();
        this.myRenderSettings = new RenderSettings();
        this.myRenderSettings.setMaxWidth(192);
        this.myRenderSettings.setMaxHeight(192);
        this.myRenderSettings.setWireframe(false);
        this.myBlankIcon = new ImageIcon(ScrubberCellRenderer.createBlankImage(DEFAULT_IMAGE_SIZE));
    }

    private static Image createBlankImage(@NotNull Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dimension", "com/android/tools/idea/editors/gfxtrace/renderers/ScrubberCellRenderer", "createBlankImage"));
        }
        BufferedImage blankImage = new BufferedImage(dimension.width, dimension.height, 12);
        Graphics2D g = blankImage.createGraphics();
        g.setPaint(UIUtil.getListForeground());
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.dispose();
        return blankImage;
    }

    public void setup(@NotNull ImageFetcher imageFetcher) {
        if (imageFetcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageFetcher", "com/android/tools/idea/editors/gfxtrace/renderers/ScrubberCellRenderer", "setup"));
        }
        this.myImageFetcher = imageFetcher;
    }

    public void addDimensionChangeListener(@NotNull DimensionChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/gfxtrace/renderers/ScrubberCellRenderer", "addDimensionChangeListener"));
        }
        this.myDimensionChangeListeners.add(listener);
    }

    public Component getListCellRendererComponent(final @NotNull JList jList, @NotNull Object data, final int index, final boolean isSelected, boolean cellHasFocus) {
        if (jList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jList", "com/android/tools/idea/editors/gfxtrace/renderers/ScrubberCellRenderer", "getListCellRendererComponent"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/android/tools/idea/editors/gfxtrace/renderers/ScrubberCellRenderer", "getListCellRendererComponent"));
        }
        assert (data instanceof ScrubberLabelData);
        final ScrubberLabelData labelData = (ScrubberLabelData)data;
        this.myScrubberLabel.setUserData(labelData);
        ImageIcon result = this.myCachedImages.get(index);
        if (result == null) {
            if (this.myOutstandingIconFetches.contains(index)) {
                ++this.myRepaintsNeeded;
            } else {
                this.myOutstandingIconFetches.add(index);
                labelData.setLoading(true);
                final AtomicBoolean shouldStopReference = this.shouldStop;
                final ImageFetcher closedImageFetcher = this.myImageFetcher;
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ImageIcon finalImageIcon;
                        ImageIcon imageIcon = null;
                        try {
                            FetchedImage fetchedImage;
                            ImageFetcher.ImageFetchHandle handle = closedImageFetcher.queueColorImage(labelData.getAtomId(), ScrubberCellRenderer.this.myRenderSettings);
                            if (handle != null && (fetchedImage = closedImageFetcher.resolveImage(handle)) != null) {
                                imageIcon = fetchedImage.createImageIcon();
                            }
                            finalImageIcon = imageIcon;
                        }
                        catch (Throwable throwable) {
                            ImageIcon finalImageIcon2 = imageIcon;
                            ApplicationManager.getApplication().invokeLater(new Runnable(finalImageIcon2){
                                final /* synthetic */ ImageIcon val$finalImageIcon;
                                {
                                    this.val$finalImageIcon = imageIcon;
                                }

                                @Override
                                public void run() {
                                    ScrubberCellRenderer.this.myOutstandingIconFetches.remove(index);
                                    if (shouldStopReference.get() || this.val$finalImageIcon == null) {
                                        return;
                                    }
                                    ScrubberCellRenderer.this.updateDefaultImageIcon(this.val$finalImageIcon);
                                    labelData.setLoading(false);
                                    labelData.setSelected(isSelected);
                                    labelData.setIcon(this.val$finalImageIcon);
                                    ScrubberCellRenderer.this.myCachedImages.put(index, this.val$finalImageIcon);
                                    jList.repaint();
                                }
                            });
                            throw throwable;
                        }
                        ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
            }
        }
        labelData.setSelected(isSelected);
        this.myScrubberLabel.setBorder(isSelected ? SELECTED_BORDER : DEFAULT_BORDER);
        this.queueInvalidateCache();
        this.myPostRenderCleanupCacheHits.add(index);
        if (this.myRepaintsNeeded > 0 && this.myTicker == null) {
            this.myTicker = ourScheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ScrubberCellRenderer.this.myRepaintsNeeded = 0;
                            jList.repaint();
                        }
                    });
                }
            }, 0L, 66L, TimeUnit.MILLISECONDS);
        } else if (this.myRepaintsNeeded == 0 && this.myTicker != null) {
            this.myTicker.cancel(false);
            this.myTicker = null;
        }
        return this.myScrubberLabel;
    }

    @NotNull
    public Dimension getCellDimensions() {
        if (this.myLargestKnownIconDimension.getWidth() > 64.0 && this.myLargestKnownIconDimension.getHeight() > 64.0) {
            Dimension dimension = new Dimension(this.myLargestKnownIconDimension.width + 10, this.myLargestKnownIconDimension.height + 10);
            if (dimension == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/renderers/ScrubberCellRenderer", "getCellDimensions"));
            }
            return dimension;
        }
        Dimension dimension = new Dimension(this.myRenderSettings.getMaxWidth() + 10, this.myRenderSettings.getMaxHeight() + 10);
        if (dimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/renderers/ScrubberCellRenderer", "getCellDimensions"));
        }
        return dimension;
    }

    @NotNull
    public ImageIcon getDefaultIcon() {
        ImageIcon imageIcon = this.myBlankIcon;
        if (imageIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/renderers/ScrubberCellRenderer", "getDefaultIcon"));
        }
        return imageIcon;
    }

    public void clearState() {
        this.clearCache();
        this.myImageFetcher = null;
    }

    public void clearCache() {
        this.shouldStop.set(true);
        this.shouldStop = new AtomicBoolean(false);
        this.myCachedImages.clear();
    }

    private void updateDefaultImageIcon(@NotNull ImageIcon newIcon) {
        if (newIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newIcon", "com/android/tools/idea/editors/gfxtrace/renderers/ScrubberCellRenderer", "updateDefaultImageIcon"));
        }
        if ((double)newIcon.getIconHeight() > this.myLargestKnownIconDimension.getHeight() || (double)newIcon.getIconWidth() > this.myLargestKnownIconDimension.getWidth()) {
            this.myLargestKnownIconDimension.setSize(Math.max(newIcon.getIconWidth(), this.myLargestKnownIconDimension.width), Math.max(newIcon.getIconHeight(), this.myLargestKnownIconDimension.height));
            this.myBlankIcon.setImage(ScrubberCellRenderer.createBlankImage(this.myLargestKnownIconDimension));
            for (DimensionChangeListener listener : this.myDimensionChangeListeners) {
                listener.notifyDimensionChanged(this.getCellDimensions());
            }
        }
    }

    private void queueInvalidateCache() {
        if (this.myPostRenderCleanupCacheHits.size() == 0) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ScrubberCellRenderer.this.myPostRenderCleanupCacheHits.size() > 2 && ScrubberCellRenderer.this.myCachedImages.size() > 45) {
                        int i;
                        Object[] hitIndices = ScrubberCellRenderer.this.myPostRenderCleanupCacheHits.toArray(new Integer[ScrubberCellRenderer.this.myPostRenderCleanupCacheHits.size()]);
                        Arrays.sort(hitIndices);
                        int midHitIndex = (Integer)hitIndices[(hitIndices.length + 1) / 2 - 1];
                        Object[] cachedKeys = ScrubberCellRenderer.this.myCachedImages.keySet().toArray(new Integer[ScrubberCellRenderer.this.myCachedImages.size()]);
                        Arrays.sort(cachedKeys);
                        int midHitIndexKeyPosition = Arrays.binarySearch(cachedKeys, (Object)midHitIndex);
                        if (midHitIndexKeyPosition < 0) {
                            midHitIndexKeyPosition = -(midHitIndexKeyPosition + 1);
                        }
                        for (i = 0; i < midHitIndexKeyPosition - 22; ++i) {
                            ScrubberCellRenderer.this.myCachedImages.remove(cachedKeys[i]);
                        }
                        for (i = midHitIndexKeyPosition - 22 + 45; i < cachedKeys.length; ++i) {
                            ScrubberCellRenderer.this.myCachedImages.remove(cachedKeys[i]);
                        }
                    }
                    ScrubberCellRenderer.this.myPostRenderCleanupCacheHits.clear();
                }
            });
        }
    }

    public static interface DimensionChangeListener {
        public void notifyDimensionChanged(@NotNull Dimension var1);
    }
}

