/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.SdkConstants;
import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.actions.OverrideResourceAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.editors.theme.StyleResolver;
import com.android.tools.idea.editors.theme.ThemeEditor;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.datamodels.ThemeEditorStyle;
import com.android.tools.idea.javadoc.AndroidJavaDocRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.AppResourceRepository;
import com.android.tools.idea.rendering.LocalResourceRepository;
import com.android.tools.idea.rendering.ResourceHelper;
import com.android.tools.lint.checks.ApiLookup;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.inspections.lint.IntellijLintClient;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorUtils {
    private static final Logger LOG = Logger.getInstance(ThemeEditorUtils.class);
    private static final Cache<String, String> ourTooltipCache = CacheBuilder.newBuilder().weakValues().maximumSize(30L).build();
    private static final Set<String> DEFAULT_THEMES = ImmutableSet.of((Object)"Theme.AppCompat.NoActionBar", (Object)"Theme.AppCompat.Light.NoActionBar");
    private static final Set<String> DEFAULT_THEMES_FALLBACK = ImmutableSet.of((Object)"Theme.Material.NoActionBar", (Object)"Theme.Material.Light.NoActionBar");
    private static final String[] CUSTOM_WIDGETS_JAR_PATHS = new String[]{"/plugins/android/lib/androidWidgets/theme-editor-widgets.jar", "/../adt/idea/android/lib/androidWidgets/theme-editor-widgets.jar"};
    public static final Comparator<ThemeEditorStyle> STYLE_COMPARATOR = new Comparator<ThemeEditorStyle>(){

        @Override
        public int compare(ThemeEditorStyle o1, ThemeEditorStyle o2) {
            if (o1.isProjectStyle() == o2.isProjectStyle()) {
                return o1.getName().compareTo(o2.getName());
            }
            return o1.isProjectStyle() ? -1 : 1;
        }
    };

    private ThemeEditorUtils() {
    }

    @NotNull
    public static String generateToolTipText(@NotNull ItemResourceValue resValue, @NotNull Module module, @NotNull Configuration configuration) {
        if (resValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resValue", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        AppResourceRepository repository = AppResourceRepository.getAppResources(module, true);
        if (repository == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
            }
            return "";
        }
        String tooltipKey = resValue.toString() + module.toString() + configuration.toString() + ((LocalResourceRepository)repository).getModificationCount();
        String cachedTooltip = (String)ourTooltipCache.getIfPresent((Object)tooltipKey);
        if (cachedTooltip != null) {
            String string = cachedTooltip;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
            }
            return string;
        }
        String tooltipContents = AndroidJavaDocRenderer.renderItemResourceWithDoc(module, configuration, resValue);
        ourTooltipCache.put((Object)tooltipKey, (Object)tooltipContents);
        String string = tooltipContents;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "generateToolTipText"));
        }
        return string;
    }

    @NotNull
    public static String getDisplayHtml(EditedStyleItem item) {
        String string = item.isDeprecated() ? "<html><body><strike>" + item.getQualifiedName() + "</strike></body></html>" : item.getQualifiedName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDisplayHtml"));
        }
        return string;
    }

    public static void openThemeEditor(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "openThemeEditor"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ThemeEditorVirtualFile file = null;
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                for (FileEditor editor : fileEditorManager.getAllEditors()) {
                    ThemeEditor themeEditor;
                    if (!(editor instanceof ThemeEditor) || (themeEditor = (ThemeEditor)editor).getVirtualFile().getProject() != project) continue;
                    file = themeEditor.getVirtualFile();
                    break;
                }
                if (file == null) {
                    file = ThemeEditorVirtualFile.getThemeEditorFile(project);
                }
                OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
                fileEditorManager.openEditor(descriptor, true);
            }
        });
    }

    public static List<EditedStyleItem> resolveAllAttributes(ThemeEditorStyle style) {
        ArrayList<EditedStyleItem> allValues = new ArrayList<EditedStyleItem>();
        TreeSet<String> namesSet = new TreeSet<String>();
        for (ThemeEditorStyle currentStyle = style; currentStyle != null; currentStyle = currentStyle.getParent()) {
            for (ItemResourceValue value : currentStyle.getValues()) {
                String itemName = StyleResolver.getQualifiedItemName(value);
                if (namesSet.contains(itemName)) continue;
                allValues.add(new EditedStyleItem(value, currentStyle));
                namesSet.add(itemName);
            }
        }
        Collections.sort(allValues, new Comparator<EditedStyleItem>(){

            @Override
            public int compare(EditedStyleItem item1, EditedStyleItem item2) {
                return item1.getQualifiedName().compareTo(item2.getQualifiedName());
            }
        });
        return allValues;
    }

    @Nullable
    public static Object extractRealValue(@NotNull EditedStyleItem item, @NotNull Class<?> desiredClass) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "extractRealValue"));
        }
        if (desiredClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desiredClass", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "extractRealValue"));
        }
        String value = item.getValue();
        if (desiredClass == Boolean.class && ("true".equals(value) || "false".equals(value))) {
            return Boolean.valueOf(value);
        }
        if (desiredClass == Integer.class && value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    public static boolean acceptsFormat(@Nullable AttributeDefinition attrDefByName, @NotNull AttributeFormat want) {
        if (want == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "want", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "acceptsFormat"));
        }
        if (attrDefByName == null) {
            return false;
        }
        return attrDefByName.getFormats().contains((Object)want);
    }

    public static boolean createColor(@NotNull Module module, @NotNull String colorName, @NotNull String colorValue) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createColor"));
        }
        if (colorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorName", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createColor"));
        }
        if (colorValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorValue", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "createColor"));
        }
        String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.COLOR);
        if (fileName == null) {
            return false;
        }
        List<String> dirNames = Collections.singletonList(ResourceFolderType.VALUES.getName());
        return AndroidResourceUtil.createValueResource(module, colorName, ResourceType.COLOR, fileName, dirNames, colorValue);
    }

    public static boolean changeColor(@NotNull Module module, @NotNull String colorName, @NotNull String colorValue) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "changeColor"));
        }
        if (colorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorName", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "changeColor"));
        }
        if (colorValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorValue", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "changeColor"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return false;
        }
        String fileName = AndroidResourceUtil.getDefaultResourceFileName(ResourceType.COLOR);
        if (fileName == null) {
            return false;
        }
        List<String> dirNames = Collections.singletonList(ResourceFolderType.VALUES.getName());
        try {
            if (!AndroidResourceUtil.changeColorResource(facet, colorName, colorValue, fileName, dirNames)) {
                return AndroidResourceUtil.createValueResource(module, colorName, ResourceType.COLOR, fileName, dirNames, colorValue);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    private static Collection<ThemeEditorStyle> findThemes(@NotNull Collection<ThemeEditorStyle> themes, final @NotNull Set<String> names) {
        if (themes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themes", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findThemes"));
        }
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findThemes"));
        }
        ImmutableSet immutableSet = ImmutableSet.copyOf((Iterable)Iterables.filter(themes, (Predicate)new Predicate<ThemeEditorStyle>(){

            public boolean apply(@Nullable ThemeEditorStyle theme) {
                return theme != null && names.contains(theme.getSimpleName());
            }
        }));
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "findThemes"));
        }
        return immutableSet;
    }

    @NotNull
    public static ImmutableList<ThemeEditorStyle> getDefaultThemes(@NotNull ThemeResolver themeResolver) {
        Collection<ThemeEditorStyle> readOnlyFrameworkThemes;
        if (themeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "themeResolver", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultThemes"));
        }
        Collection<ThemeEditorStyle> editableThemes = themeResolver.getLocalThemes();
        HashSet readOnlyLibThemes = new HashSet(themeResolver.getProjectThemes());
        readOnlyLibThemes.removeAll(editableThemes);
        Collection<ThemeEditorStyle> foundThemes = ThemeEditorUtils.findThemes((Collection<ThemeEditorStyle>)readOnlyLibThemes, DEFAULT_THEMES);
        if (foundThemes.isEmpty() && (foundThemes = ThemeEditorUtils.findThemes(readOnlyFrameworkThemes = themeResolver.getFrameworkThemes(), DEFAULT_THEMES_FALLBACK)).isEmpty()) {
            foundThemes.addAll((Collection<ThemeEditorStyle>)readOnlyLibThemes);
            foundThemes.addAll(readOnlyFrameworkThemes);
        }
        TreeSet<ThemeEditorStyle> temporarySet = new TreeSet<ThemeEditorStyle>(STYLE_COMPARATOR);
        temporarySet.addAll(foundThemes);
        ImmutableList immutableList = ImmutableList.copyOf(temporarySet);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getDefaultThemes"));
        }
        return immutableList;
    }

    public static int getMinApiLevel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getMinApiLevel"));
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return 1;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.get(facet);
        return moduleInfo.getMinSdkVersion().getApiLevel();
    }

    @Nullable
    public static URL getCustomWidgetsJarUrl() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path : CUSTOM_WIDGETS_JAR_PATHS) {
            String jarPath = homePath + path;
            VirtualFile root = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath));
            if (root != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)root);
                if (!rootFile.exists()) continue;
                try {
                    LOG.debug("Theme editor custom widgets found at " + jarPath);
                    return rootFile.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                    continue;
                }
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.error("Unable to find theme-editor-widgets.jar in paths:\n" + notFoundPaths.toString());
        return null;
    }

    public static int getOriginalApiLevel(@NotNull String name, @NotNull Project project) {
        boolean isAttribute;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getOriginalApiLevel"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "getOriginalApiLevel"));
        }
        if (name.startsWith("android:")) {
            isAttribute = true;
        } else if (name.startsWith("@android:")) {
            isAttribute = false;
        } else {
            return -1;
        }
        ApiLookup apiLookup = IntellijLintClient.getApiLookup(project);
        assert (apiLookup != null);
        if (isAttribute) {
            return apiLookup.getFieldVersion("android/R$attr", name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN));
        }
        String[] namePieces = name.substring("@android:".length()).split("/");
        if (namePieces.length == 2) {
            return apiLookup.getFieldVersion("android/R$" + namePieces[0], AndroidResourceUtil.getFieldNameByResourceName(namePieces[1]));
        }
        return -1;
    }

    public static void copyTheme(int apiLevel, @NotNull XmlTag toBeCopied) {
        if (toBeCopied == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toBeCopied", "com/android/tools/idea/editors/theme/ThemeEditorUtils", "copyTheme"));
        }
        PsiFile file = toBeCopied.getContainingFile();
        assert (file instanceof XmlFile) : file;
        ResourceFolderType folderType = ResourceHelper.getFolderType(file);
        assert (folderType != null) : file;
        FolderConfiguration config = ResourceHelper.getFolderConfiguration(file);
        assert (config != null) : file;
        VersionQualifier qualifier = new VersionQualifier(apiLevel);
        config.setVersionQualifier(qualifier);
        String folder = config.getFolderName(folderType);
        AndroidLintQuickFix action = OverrideResourceAction.createFix(folder);
        AndroidQuickfixContexts.DesignerContext context = AndroidQuickfixContexts.DesignerContext.getInstance();
        action.apply((PsiElement)toBeCopied, (PsiElement)toBeCopied, context);
    }
}

