/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.deployment;

import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentManager {
    public static DeploymentManager getInstance(Project project) {
        return (DeploymentManager)ServiceManager.getService((Project)project, DeploymentManager.class);
    }

    public abstract void setDeploymentStatus(DeploymentModel var1, DeploymentStatus var2, CommonModel var3, J2EEServerInstance var4);

    @NotNull
    public abstract DeploymentStatus getDeploymentStatus(@NotNull DeploymentModel var1, CommonModel var2);

    public abstract boolean isKeepDeployedAfterDisconnect(DeploymentModel var1, CommonModel var2);

    public abstract void setKeepDeployedAfterDisconnect(DeploymentModel var1, CommonModel var2, boolean var3);

    public abstract void initKeepDeployedAfterDisconnect(J2EEServerInstance var1, CommonModel var2);

    public void deployAllModules(J2EEServerInstance instance, CommonModel runConfiguration, boolean makeBeforeDeploy, @Nullable Runnable callback) {
        this.deployModules(instance, runConfiguration, makeBeforeDeploy, callback, Collections.<DeploymentModel>emptyList());
    }

    public abstract void deployModules(J2EEServerInstance var1, CommonModel var2, boolean var3, @Nullable Runnable var4, List<DeploymentModel> var5);

    public abstract void undeployNonKeptModules(J2EEServerInstance var1, CommonModel var2);

    public abstract void clean(J2EEServerInstance var1, CommonModel var2);

    @Nullable
    public abstract File getDeploymentSource(DeploymentModel var1);

    @Nullable
    public abstract String getDeploymentSourcePath(DeploymentModel var1);

    public abstract void updateAllDeploymentStatus(J2EEServerInstance var1, CommonModel var2);

    @Nullable
    public abstract DeploymentModel getModelForFacet(@NotNull CommonModel var1, @NotNull JavaeeFacet var2);

    @NotNull
    public abstract List<Artifact> getSupportedArtifacts(@NotNull DeploymentProvider var1);
}

