/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class AbstractMethodResolveConverter<T extends JavaeeDomModelElement>
extends ResolvingConverter<PsiMethod> {
    public static final String ALL_METHODS = "*";
    private final Class<T> myDomMethodClass;

    protected AbstractMethodResolveConverter(Class<T> domMethodClass) {
        this.myDomMethodClass = domMethodClass;
    }

    @NotNull
    protected abstract Collection<PsiClass> getPsiClasses(T var1, ConvertContext var2);

    @Nullable
    protected abstract MethodParams getMethodParams(@NotNull T var1);

    public void bindReference(GenericDomValue<PsiMethod> genericValue, ConvertContext context, PsiElement element) {
        assert (element instanceof PsiMethod) : "PsiMethod expected";
        PsiMethod psiMethod = (PsiMethod)element;
        T parent = this.getParent(context);
        MethodParams methodParams = this.getMethodParams(parent);
        genericValue.setStringValue(psiMethod.getName());
        if (methodParams != null) {
            methodParams.undefine();
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                methodParams.addMethodParam().setValue((Object)parameter.getType());
            }
        }
    }

    public String getErrorMessage(String s, ConvertContext context) {
        T t = this.getParent(context);
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{IdeBundle.message((String)"element.method", (Object[])new Object[0]), AbstractMethodResolveConverter.getReferenceCanonicalText(s, this.getMethodParams(t))});
    }

    @NotNull
    protected final T getParent(ConvertContext context) {
        JavaeeDomModelElement javaeeDomModelElement = (JavaeeDomModelElement)context.getInvocationElement().getParentOfType(this.myDomMethodClass, true);
        if (javaeeDomModelElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/AbstractMethodResolveConverter", "getParent"));
        }
        return (T)javaeeDomModelElement;
    }

    public boolean isReferenceTo(final @NotNull PsiElement element, final String stringValue, PsiMethod resolveResult, ConvertContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javaee/model/AbstractMethodResolveConverter", "isReferenceTo"));
        }
        if (super.isReferenceTo(element, stringValue, (Object)resolveResult, context)) {
            return true;
        }
        final Ref result = new Ref((Object)Boolean.FALSE);
        this.processMethods(context, new Processor<PsiMethod>(){

            public boolean process(PsiMethod method) {
                if (method.equals(element)) {
                    result.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }
        }, new Function<PsiClass, PsiMethod[]>(){

            public PsiMethod[] fun(PsiClass s) {
                return s.findMethodsByName(stringValue, true);
            }
        });
        return (Boolean)result.get();
    }

    protected void processMethods(ConvertContext context, Processor<PsiMethod> processor, Function<PsiClass, PsiMethod[]> methodGetter) {
        for (PsiClass psiClass : this.getPsiClasses(this.getParent(context), context)) {
            if (psiClass == null) continue;
            for (PsiMethod psiMethod : (PsiMethod[])methodGetter.fun((Object)psiClass)) {
                if (processor.process((Object)psiMethod)) continue;
                return;
            }
        }
    }

    @NotNull
    public Collection<? extends PsiMethod> getVariants(ConvertContext context) {
        LinkedHashSet methodList = new LinkedHashSet();
        this.processMethods(context, (Processor<PsiMethod>)new CommonProcessors.CollectProcessor(methodList), new Function<PsiClass, PsiMethod[]>(){

            public PsiMethod[] fun(PsiClass s) {
                List list = ContainerUtil.findAll(AbstractMethodResolveConverter.this.getVariants(s), (Condition)new Condition<PsiMethod>(){

                    public boolean value(PsiMethod object) {
                        return AbstractMethodResolveConverter.methodSuits(object);
                    }
                });
                return list.toArray(new PsiMethod[list.size()]);
            }
        });
        LinkedHashSet linkedHashSet = methodList;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/AbstractMethodResolveConverter", "getVariants"));
        }
        return linkedHashSet;
    }

    protected Collection<PsiMethod> getVariants(PsiClass s) {
        return Arrays.asList(s.getAllMethods());
    }

    public static boolean methodSuits(PsiMethod psiMethod) {
        if (psiMethod.isConstructor()) {
            return false;
        }
        return psiMethod.getContainingClass().isInterface() || psiMethod.hasModifierProperty("public") && !psiMethod.hasModifierProperty("static");
    }

    public Set<String> getAdditionalVariants() {
        return Collections.singleton(ALL_METHODS);
    }

    public PsiMethod fromString(final String methodName, final ConvertContext context) {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.processMethods(context, (Processor<PsiMethod>)processor, new Function<PsiClass, PsiMethod[]>(){

            public PsiMethod[] fun(PsiClass s) {
                PsiMethod method = AbstractMethodResolveConverter.findMethod(s, methodName, AbstractMethodResolveConverter.this.getMethodParams(AbstractMethodResolveConverter.this.getParent(context)));
                if (method != null && AbstractMethodResolveConverter.methodSuits(method)) {
                    return new PsiMethod[]{method};
                }
                return PsiMethod.EMPTY_ARRAY;
            }
        });
        if (processor.isFound()) {
            return (PsiMethod)processor.getFoundValue();
        }
        this.processMethods(context, (Processor<PsiMethod>)processor, new Function<PsiClass, PsiMethod[]>(){

            public PsiMethod[] fun(PsiClass s) {
                return s.findMethodsByName(methodName, true);
            }
        });
        return (PsiMethod)processor.getFoundValue();
    }

    public String toString(PsiMethod method, ConvertContext context) {
        return method.getName();
    }

    public static String getReferenceCanonicalText(String name, @Nullable MethodParams methodParams) {
        StringBuilder sb = new StringBuilder(name);
        if (methodParams == null) {
            sb.append("()");
        } else if (methodParams.getXmlTag() != null) {
            sb.append("(");
            List<GenericDomValue<PsiType>> list = methodParams.getMethodParams();
            boolean first = true;
            for (GenericDomValue<PsiType> value : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(value.getStringValue());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Nullable
    public static PsiMethod findMethod(PsiClass psiClass, String methodName, final @Nullable MethodParams methodParameters) {
        if (psiClass == null || methodName == null) {
            return null;
        }
        return (PsiMethod)ContainerUtil.find((Object[])psiClass.findMethodsByName(methodName, true), (Condition)new Condition<PsiMethod>(){

            public boolean value(PsiMethod object) {
                return AbstractMethodResolveConverter.methodParamsMatchSignature(methodParameters, object);
            }
        });
    }

    public static boolean methodParamsMatchSignature(@Nullable MethodParams params, PsiMethod psiMethod) {
        if (params != null && params.getXmlTag() == null) {
            return true;
        }
        PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
        if (params == null) {
            return parameters.length == 0;
        }
        List<GenericDomValue<PsiType>> methodParams = params.getMethodParams();
        if (methodParams.size() != parameters.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (Comparing.equal((Object)parameters[i].getType(), (Object)methodParams.get(i).getValue())) continue;
            return false;
        }
        return true;
    }
}

