/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.enums.MethodIntf;
import com.intellij.javaee.model.xml.ejb.Method;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.psi.PsiClass;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.converters.AbstractMethodResolveConverter;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbMethodResolveConverter
extends AbstractMethodResolveConverter<Method> {
    public EjbMethodResolveConverter() {
        super(Method.class);
    }

    @NotNull
    protected Collection<PsiClass> getPsiClasses(Method parent, ConvertContext context) {
        Collection<PsiClass> collection = EjbMethodResolveConverter.getTargetClasses((EnterpriseBean)parent.getEnterpriseBean().getValue(), (MethodIntf)((Object)parent.getMethodIntf().getValue()), true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/EjbMethodResolveConverter", "getPsiClasses"));
        }
        return collection;
    }

    public static Collection<PsiClass> getTargetClasses(@Nullable EnterpriseBean ejb, @Nullable MethodIntf methodIntf, boolean includeEjbClass) {
        HashSet<PsiClass> targetClasses = new HashSet<PsiClass>();
        boolean allInterfaces = false;
        MethodIntf curMethodIntf = methodIntf;
        if (methodIntf == null) {
            allInterfaces = true;
            curMethodIntf = MethodIntf.HOME;
            if (includeEjbClass && ejb != null) {
                targetClasses.add((PsiClass)ejb.getEjbClass().getValue());
            }
        }
        switch (curMethodIntf) {
            case HOME: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull((Object)((EjbWithHome)ejb).getHome().getValue(), targetClasses);
                }
                if (!allInterfaces) break;
            }
            case LOCAL_HOME: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull((Object)((EjbWithHome)ejb).getLocalHome().getValue(), targetClasses);
                }
                if (!allInterfaces) break;
            }
            case REMOTE: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull((Object)((EjbWithHome)ejb).getRemote().getValue(), targetClasses);
                }
                if (ejb instanceof SessionBean) {
                    for (GenericValue<PsiClass> genericValue : ((SessionBean)ejb).getBusinessRemotes()) {
                        ContainerUtil.addIfNotNull((Object)genericValue.getValue(), targetClasses);
                    }
                }
                if (!allInterfaces) break;
            }
            case LOCAL: {
                if (ejb instanceof EjbWithHome) {
                    ContainerUtil.addIfNotNull((Object)((EjbWithHome)ejb).getLocal().getValue(), targetClasses);
                }
                if (ejb instanceof SessionBean) {
                    for (GenericValue<PsiClass> genericValue : ((SessionBean)ejb).getBusinessLocals()) {
                        ContainerUtil.addIfNotNull((Object)genericValue.getValue(), targetClasses);
                    }
                } else if (ejb instanceof MessageDrivenBean) {
                    ContainerUtil.addIfNotNull((Object)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue(), targetClasses);
                }
                if (!allInterfaces) break;
            }
            case SERVICE_ENDPOINT: {
                if (ejb instanceof SessionBean) {
                    ContainerUtil.addIfNotNull((Object)((SessionBean)ejb).getServiceEndpoint().getValue(), targetClasses);
                }
                if (!allInterfaces) break;
            }
            case MESSAGE_ENDPOINT: {
                if (ejb instanceof MessageDrivenBean) {
                    ContainerUtil.addIfNotNull((Object)((MessageDrivenBean)ejb).getMessageListenerInterface().getValue(), targetClasses);
                }
                if (!allInterfaces) break;
            }
            case TIMER: {
                if (allInterfaces || ejb == null) break;
                ContainerUtil.addIfNotNull((Object)ejb.getEjbClass().getValue(), targetClasses);
            }
        }
        return targetClasses;
    }

    @NotNull
    protected MethodParams getMethodParams(@NotNull Method parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javaee/model/EjbMethodResolveConverter", "getMethodParams"));
        }
        MethodParams methodParams = parent.getMethodParams();
        if (methodParams == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/EjbMethodResolveConverter", "getMethodParams"));
        }
        return methodParams;
    }
}

