/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.javaee.model.AbstractMethodResolveConverter;
import com.intellij.javaee.model.common.ejb.EjbCommonModelUtil;
import com.intellij.javaee.model.xml.JavaeeDomModelElement;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.javaee.model.xml.ejb.Interceptor;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class InterceptorMethodResolveConverter<T extends JavaeeDomModelElement>
extends AbstractMethodResolveConverter<T> {
    public InterceptorMethodResolveConverter(Class<T> domMethodClass) {
        super(domMethodClass);
    }

    @Override
    protected MethodParams getMethodParams(@NotNull T parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javaee/model/InterceptorMethodResolveConverter", "getMethodParams"));
        }
        return null;
    }

    @Override
    public Set<String> getAdditionalVariants() {
        return Collections.emptySet();
    }

    @Override
    protected Collection<PsiMethod> getVariants(PsiClass s) {
        return ContainerUtil.findAll((Object[])s.getAllMethods(), (Condition)new Condition<PsiMethod>(){

            public boolean value(PsiMethod object) {
                return object.getParameterList().getParametersCount() == 0;
            }
        });
    }

    @Override
    @NotNull
    protected Collection<PsiClass> getPsiClasses(T parent, ConvertContext context) {
        GenericDomValue<PsiClass> lifecycleCallbackClass = this.getPsiClassValue(parent);
        if (lifecycleCallbackClass.getXmlTag() == null) {
            Interceptor interceptor = (Interceptor)parent.getParentOfType(Interceptor.class, true);
            if (interceptor != null) {
                List<PsiClass> list = Arrays.asList((PsiClass)interceptor.getInterceptorClass().getValue());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/InterceptorMethodResolveConverter", "getPsiClasses"));
                }
                return list;
            }
            EjbBase base = (EjbBase)parent.getParentOfType(EjbBase.class, true);
            if (base != null) {
                List<PsiClass> list = Arrays.asList((PsiClass)EjbCommonModelUtil.getMergedEnterpriseBean(base).getEjbClass().getValue());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/InterceptorMethodResolveConverter", "getPsiClasses"));
                }
                return list;
            }
        }
        List<PsiClass> list = Arrays.asList((PsiClass)lifecycleCallbackClass.getValue());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/InterceptorMethodResolveConverter", "getPsiClasses"));
        }
        return list;
    }

    protected abstract GenericDomValue<PsiClass> getPsiClassValue(T var1);
}

