/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model;

import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.model.xml.ejb.MethodParams;
import com.intellij.javaee.model.xml.ejb.Query;
import com.intellij.javaee.model.xml.ejb.QueryMethod;
import com.intellij.psi.PsiClass;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.converters.AbstractMethodResolveConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class QueryMethodResolveConverter
extends AbstractMethodResolveConverter<QueryMethod> {
    public QueryMethodResolveConverter() {
        super(QueryMethod.class);
    }

    @NotNull
    protected Collection<PsiClass> getPsiClasses(QueryMethod parent, ConvertContext context) {
        EntityBean bean;
        Query query = (Query)parent.getParent();
        if (query != null && (bean = (EntityBean)query.getParent()) != null) {
            String value = parent.getMethodName().getStringValue();
            if (value != null && value.startsWith("find")) {
                List<PsiClass> list = Arrays.asList((PsiClass)bean.getHome().getValue(), (PsiClass)bean.getLocalHome().getValue());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/QueryMethodResolveConverter", "getPsiClasses"));
                }
                return list;
            }
            List<PsiClass> list = Arrays.asList((PsiClass)bean.getEjbClass().getValue());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/QueryMethodResolveConverter", "getPsiClasses"));
            }
            return list;
        }
        List<PsiClass> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/QueryMethodResolveConverter", "getPsiClasses"));
        }
        return list;
    }

    public Set<String> getAdditionalVariants() {
        return Collections.emptySet();
    }

    @NotNull
    protected MethodParams getMethodParams(@NotNull QueryMethod parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/javaee/model/QueryMethodResolveConverter", "getMethodParams"));
        }
        MethodParams methodParams = parent.getMethodParams();
        if (methodParams == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/QueryMethodResolveConverter", "getMethodParams"));
        }
        return methodParams;
    }
}

