/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.jam;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationAttributeMeta;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.model.jam.JamInitParam;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericValue;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamFilter
extends CommonModelElement.PsiBase
implements CommonFilter,
CommonServletMapping<CommonFilter>,
JamElement {
    public static final JamStringAttributeMeta.Single<String> NAME_META = JamAttributeMeta.singleString((String)"filterName");
    public static final JamStringAttributeMeta.Collection<String> URL_PATTERNS_META = JamAttributeMeta.collectionString((String)"urlPatterns");
    public static final JamStringAttributeMeta.Collection<CommonServlet> SERVLET_NAMES_META = JamAttributeMeta.collectionString((String)"servletNames", (JamConverter)new JamSimpleReferenceConverter<CommonServlet>(){

        public CommonServlet fromString(final @Nullable String s, JamStringAttributeElement<CommonServlet> context) {
            if (s == null) {
                return null;
            }
            WebFacet facet = WebUtil.getWebFacet((PsiElement)context.getPsiElement());
            if (facet == null) {
                return null;
            }
            return (CommonServlet)ContainerUtil.find(facet.getWebModel().getServlets(), (Condition)new Condition<CommonServlet>(){

                public boolean value(CommonServlet commonServlet) {
                    return s.equals(commonServlet.getServletName().getStringValue());
                }
            });
        }

        public Collection<CommonServlet> getVariants(JamStringAttributeElement<CommonServlet> context) {
            WebFacet facet = WebUtil.getWebFacet((PsiElement)context.getPsiElement());
            if (facet == null) {
                return Collections.emptyList();
            }
            return facet.getWebModel().getServlets();
        }
    });
    public static final JamAnnotationAttributeMeta.Collection<JamInitParam> INIT_PARAMS_META = JamAttributeMeta.annoCollection((String)"initParams", (JamAnnotationMeta)JamInitParam.INIT_PARAM_ANNO_META, JamInitParam.class);
    @NonNls
    public static final String ANNO_NAME = "javax.servlet.annotation.WebFilter";
    public static final JamAnnotationMeta FILTER_ANNO_META = new JamAnnotationMeta("javax.servlet.annotation.WebFilter").addAttribute(NAME_META).addAttribute(URL_PATTERNS_META).addAttribute(INIT_PARAMS_META).addAttribute(SERVLET_NAMES_META);
    public static final JamClassMeta<JamFilter> FILTER_CLASS_META = new JamClassMeta(JamFilter.class).addAnnotation(FILTER_ANNO_META);

    @Override
    @JamPsiConnector
    public abstract PsiClass getPsiClass();

    @JamPsiValidity
    public abstract boolean isPsiValid();

    @NotNull
    public PsiElement getPsiElement() {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/jam/JamFilter", "getPsiElement"));
        }
        return psiClass;
    }

    @NotNull
    public JamStringAttributeElement<String> getFilterName() {
        JamStringAttributeElement jamStringAttributeElement = (JamStringAttributeElement)FILTER_ANNO_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), NAME_META);
        if (jamStringAttributeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/jam/JamFilter", "getFilterName"));
        }
        return jamStringAttributeElement;
    }

    @Override
    public List<JamStringAttributeElement<String>> getUrlPatterns() {
        return (List)FILTER_ANNO_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), URL_PATTERNS_META);
    }

    public List<? extends GenericValue<CommonServlet>> getServletNames() {
        return SERVLET_NAMES_META.getJam(FILTER_ANNO_META.getAnnotationRef((PsiModifierListOwner)this.getPsiClass()));
    }

    public List<JamInitParam> getInitParams() {
        return (List)FILTER_ANNO_META.getAttribute((PsiModifierListOwner)this.getPsiClass(), INIT_PARAMS_META);
    }

    @Override
    public JamInitParam addInitParam() {
        return (JamInitParam)INIT_PARAMS_META.addAttribute(PsiElementRef.real((PsiElement)FILTER_ANNO_META.getAnnotation((PsiModifierListOwner)this.getPsiClass())));
    }

    @Override
    public CommonFilter getServlet() {
        return this;
    }

    @Override
    public PsiElement getMappingElement() {
        return FILTER_ANNO_META.getAnnotation((PsiModifierListOwner)this.getPsiClass());
    }
}

