/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.localRun;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.run.localRun.CommandLineExecutableObject;
import com.intellij.javaee.run.localRun.ExecutableObject;
import com.intellij.javaee.run.localRun.ScriptUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptExecutableObject
implements ExecutableObject {
    private final String myScript;
    @Nullable
    private final File myDirectoryForScript;
    private final String myFileName;

    public ScriptExecutableObject(String script, @Nullable File directoryForScript, @NonNls String fileName) {
        this.myScript = script;
        this.myDirectoryForScript = directoryForScript;
        this.myFileName = fileName;
    }

    public ScriptExecutableObject(String script, @NonNls String fileName) {
        this(script, null, fileName);
    }

    @Override
    public String getDisplayString() {
        return this.myScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSProcessHandler createProcessHandler(String workingDirectory, Map<String, String> envVariables) throws ExecutionException {
        File executableFile;
        try {
            executableFile = this.createNewExecutableFile();
            FileOutputStream outputStream = new FileOutputStream(executableFile);
            try {
                FileUtil.copy((InputStream)new ByteArrayInputStream(this.getScript().getBytes()), (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw new ExecutionException(J2EEBundle.message("message.text.error.while.creating.temp.file", e.getLocalizedMessage()));
        }
        final File toDelete = this.myDirectoryForScript == null ? executableFile.getParentFile() : executableFile;
        toDelete.deleteOnExit();
        OSProcessHandler result = this.createExecutable(executableFile).createProcessHandler(workingDirectory, envVariables);
        result.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                FileUtil.delete((File)toDelete);
            }
        });
        return result;
    }

    @NotNull
    protected ExecutableObject createExecutable(@NotNull File executableFile) {
        if (executableFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executableFile", "com/intellij/javaee/run/localRun/ScriptExecutableObject", "createExecutable"));
        }
        CommandLineExecutableObject commandLineExecutableObject = new CommandLineExecutableObject(new String[]{executableFile.getAbsolutePath()}, null);
        if (commandLineExecutableObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/run/localRun/ScriptExecutableObject", "createExecutable"));
        }
        return commandLineExecutableObject;
    }

    protected String getScript() throws ExecutionException {
        return this.myScript;
    }

    private File createNewExecutableFile() throws IOException {
        if (this.myDirectoryForScript == null) {
            File tempDirectory = FileUtil.createTempDirectory((String)"exec", (String)"script");
            return ScriptUtil.createScriptFile(tempDirectory, this.myFileName);
        }
        this.myDirectoryForScript.mkdirs();
        File file = FileUtil.findSequentNonexistentFile((File)this.myDirectoryForScript, (String)this.myFileName, (String)ScriptUtil.getScriptExtension());
        FileUtil.createIfDoesntExist((File)file);
        ScriptUtil.makeExecutable(file);
        return file;
    }
}

