/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion.provider;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.util.CssCompletionUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;

public class LessGuardKeywordsCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/less/completion/provider/LessGuardKeywordsCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/completion/provider/LessGuardKeywordsCompletionProvider", "addCompletions"));
        }
        PsiElement prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)parameters.getPosition());
        if (prevLeaf != null && (prevLeaf.getParent() instanceof LESSMixinInvocation || PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, CssSimpleSelector.class) != null)) {
            result.addElement(CssCompletionUtil.lookupForKeyword((String)"when"));
        } else if (prevLeaf != null && LESSTokenTypes.GUARD_KEYWORDS.contains(prevLeaf.getNode().getElementType())) {
            result.addElement(CssCompletionUtil.lookupForKeyword((String)"not"));
        } else {
            result.addElement(CssCompletionUtil.lookupForKeyword((String)"and"));
            result.addElement(CssCompletionUtil.lookupForKeyword((String)"or"));
        }
    }
}

