/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion.provider;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.index.CssIndexUtil;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSUtil;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.impl.LESSPrimitiveMixin;
import org.jetbrains.plugins.less.psi.stubs.LessMixinIndex;

public class LessMixinCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final boolean myInPureMixinInvocation;

    public LessMixinCompletionProvider(boolean inPureMixinInvocation) {
        this.myInPureMixinInvocation = inPureMixinInvocation;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/less/completion/provider/LessMixinCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/less/completion/provider/LessMixinCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        if (this.myInPureMixinInvocation) {
            LESSMixinInvocation mixinInvocation = (LESSMixinInvocation)PsiTreeUtil.getParentOfType((PsiElement)position, LESSMixinInvocation.class);
            String invocationNamespace = mixinInvocation != null ? mixinInvocation.getNamespace() : "";
            String prefix = mixinInvocation != null ? mixinInvocation.getPrefix() : "";
            HashSet ignoreSelectors = Sets.newHashSet();
            LessMixinCompletionProvider.addCompletions(result, position, project, (PsiElement)mixinInvocation, invocationNamespace, prefix, parameters.getOriginalFile(), ignoreSelectors);
            if (mixinInvocation != null) {
                PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)mixinInvocation);
                while (nextLeaf != null && nextLeaf.getText().trim().isEmpty()) {
                    nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
                }
                if (nextLeaf != null && nextLeaf.getNode().getElementType() == CssElementTypes.CSS_RBRACE) {
                    LessMixinCompletionProvider.addSelectorCompletions(parameters.getOriginalFile(), prefix, result, ignoreSelectors);
                }
            }
        } else {
            CssSelectorList cssSelectorList = (CssSelectorList)PsiTreeUtil.getParentOfType((PsiElement)position, CssSelectorList.class);
            CssSelectorSuffix cssSelectorSuffix = (CssSelectorSuffix)PsiTreeUtil.getParentOfType((PsiElement)position, CssSelectorSuffix.class);
            if (cssSelectorList != null && cssSelectorSuffix != null) {
                PsiElement simpleSelector = PsiTreeUtil.getParentOfType((PsiElement)cssSelectorSuffix, CssSimpleSelector.class);
                if (simpleSelector == null || !simpleSelector.getText().equals(cssSelectorSuffix.getText())) {
                    return;
                }
                CssSelector[] selectors = cssSelectorList.getSelectors();
                if (selectors.length == 1) {
                    CssSelector cssSelector = selectors[0];
                    String invocationNamespace = LESSUtil.getNamespaceForSelector(cssSelector, cssSelectorSuffix);
                    String prefix = LESSUtil.getSelectorPrefix(cssSelectorSuffix);
                    LessMixinCompletionProvider.addCompletions(result, position, project, (PsiElement)cssSelectorSuffix, invocationNamespace, prefix, parameters.getOriginalFile(), null);
                }
            }
        }
    }

    private static void addSelectorCompletions(PsiFile psiFile, String prefix, final CompletionResultSet resultSet, final Set<String> ignoreSelectors) {
        final CssSelectorSuffixType selectorType = "#".equals(prefix) ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
        CssIndexUtil.processAllSelectorNamesInScope((CssSelectorSuffixType)selectorType, (Project)psiFile.getProject(), (GlobalSearchScope)GlobalSearchScope.fileScope((PsiFile)psiFile), (Processor)new Processor<String>(){

            public boolean process(String s) {
                if (!ignoreSelectors.contains(s)) {
                    resultSet.addElement((LookupElement)LookupElementBuilder.create((String)s).withIcon(selectorType.getIcon()));
                }
                return true;
            }
        });
    }

    private static void addCompletions(final CompletionResultSet result, PsiElement position, Project project, final @Nullable PsiElement mixinInvocation, final String invocationNamespace, String prefix, PsiFile file, final Collection<String> ignoreSelectors) {
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        final Set importedFiles = CssUtil.getImportedFiles((PsiFile)file, (PsiElement)position, (boolean)false);
        for (String name : StubIndex.getInstance().getAllKeys(LessMixinIndex.KEY, project)) {
            if (name.isEmpty() || !name.startsWith(prefix)) continue;
            LessMixinIndex.process(name, project, scope, (Processor<? super LESSMixin>)new Processor<LESSMixin>(){

                public boolean process(LESSMixin mixin) {
                    if (LESSUtil.isMixinMatchesWithInvocation(mixin, mixinInvocation, invocationNamespace)) {
                        if (ignoreSelectors != null && mixin instanceof LESSPrimitiveMixin) {
                            ignoreSelectors.add(mixin.getFullName());
                        }
                        boolean validResult = importedFiles.contains(mixin.getContainingFile().getVirtualFile());
                        result.addElement(LESSUtil.createMixinLookupItem(mixin, validResult));
                    }
                    return true;
                }
            });
        }
    }
}

