/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.lexer.LESSHighlightingLexer;
import org.jetbrains.plugins.less.lexer.LESSTokenTypes;

public class LESSSyntaxHighlighter
extends CssHighlighter {
    private static final Map<IElementType, TextAttributesKey> mapping;
    @NonNls
    private static final String VARIABLE_ID = "LESS_VARIABLE";
    @NonNls
    private static final String JS_CODE_DELIM_ID = "LESS_JS_CODE_DELIM";
    @NonNls
    private static final String INJECTED_CODE_ID = "LESS_INJECTED_CODE";
    @NonNls
    private static final String KEYWORD_ID = "LESS_KEYWORD";
    public static final TextAttributesKey VARIABLE;
    public static final TextAttributesKey JS_CODE_DELIM;
    public static final TextAttributesKey INJECTED_CODE;
    public static final TextAttributesKey KEYWORD;
    public static final TextAttributesKey IDENTIFIER;
    public static final TextAttributesKey STRING;
    public static final TextAttributesKey IMPORTANT;
    public static final TextAttributesKey PROPERTY_NAME;
    public static final TextAttributesKey PROPERTY_VALUE;
    public static final TextAttributesKey FUNCTION;
    public static final TextAttributesKey URL;
    public static final TextAttributesKey NUMBER;
    public static final TextAttributesKey COLOR;
    public static final TextAttributesKey PSEUDO;
    public static final TextAttributesKey COMMENT;
    public static final TextAttributesKey TAG_NAME;
    public static final TextAttributesKey ID_SELECTOR;
    public static final TextAttributesKey UNICODE_RANGE;
    public static final TextAttributesKey PARENTHESES;
    public static final TextAttributesKey BRACKETS;
    public static final TextAttributesKey BRACES;
    public static final TextAttributesKey DOT;
    public static final TextAttributesKey SEMICOLON;
    public static final TextAttributesKey COLON;
    public static final TextAttributesKey COMMA;
    public static final TextAttributesKey OPERATORS;
    public static final TextAttributesKey BAD_CHARACTER;

    @NotNull
    public Lexer getHighlightingLexer() {
        LESSHighlightingLexer lESSHighlightingLexer = new LESSHighlightingLexer(CssElementDescriptorFactory2.getInstance().getValueIdentifiers());
        if (lESSHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/highlighting/LESSSyntaxHighlighter", "getHighlightingLexer"));
        }
        return lESSHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (LESSTokenTypes.GUARD_KEYWORDS.contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = LESSSyntaxHighlighter.pack((TextAttributesKey)KEYWORD);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/highlighting/LESSSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (LESSTokenTypes.OPERATORS.contains(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = LESSSyntaxHighlighter.pack((TextAttributesKey)OPERATORS);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/highlighting/LESSSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        if (mapping.containsKey(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = LESSSyntaxHighlighter.pack((TextAttributesKey)mapping.get(tokenType));
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/highlighting/LESSSyntaxHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/less/highlighting/LESSSyntaxHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    static {
        VARIABLE = TextAttributesKey.createTextAttributesKey((String)VARIABLE_ID, (TextAttributesKey)DefaultLanguageHighlighterColors.INSTANCE_FIELD);
        JS_CODE_DELIM = TextAttributesKey.createTextAttributesKey((String)JS_CODE_DELIM_ID, (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        INJECTED_CODE = TextAttributesKey.createTextAttributesKey((String)INJECTED_CODE_ID, (TextAttributesKey)HighlighterColors.TEXT);
        KEYWORD = TextAttributesKey.createTextAttributesKey((String)KEYWORD_ID, (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        IDENTIFIER = TextAttributesKey.createTextAttributesKey((String)"LESS_IDENT", (TextAttributesKey)CssHighlighter.CSS_IDENT);
        STRING = TextAttributesKey.createTextAttributesKey((String)"LESS_STRING", (TextAttributesKey)CssHighlighter.CSS_STRING);
        IMPORTANT = TextAttributesKey.createTextAttributesKey((String)"LESS_IMPORTANT", (TextAttributesKey)CssHighlighter.CSS_IMPORTANT);
        PROPERTY_NAME = TextAttributesKey.createTextAttributesKey((String)"LESS_PROPERTY_NAME", (TextAttributesKey)CssHighlighter.CSS_PROPERTY_NAME);
        PROPERTY_VALUE = TextAttributesKey.createTextAttributesKey((String)"LESS_PROPERTY_VALUE", (TextAttributesKey)CssHighlighter.CSS_PROPERTY_VALUE);
        FUNCTION = TextAttributesKey.createTextAttributesKey((String)"LESS_FUNCTION", (TextAttributesKey)CssHighlighter.CSS_FUNCTION);
        URL = TextAttributesKey.createTextAttributesKey((String)"LESS_URL", (TextAttributesKey)CssHighlighter.CSS_URL);
        NUMBER = TextAttributesKey.createTextAttributesKey((String)"LESS_NUMBER", (TextAttributesKey)CssHighlighter.CSS_NUMBER);
        COLOR = TextAttributesKey.createTextAttributesKey((String)"LESS_COLOR", (TextAttributesKey)CssHighlighter.CSS_COLOR);
        PSEUDO = TextAttributesKey.createTextAttributesKey((String)"LESS_PSEUDO", (TextAttributesKey)CssHighlighter.CSS_PSEUDO);
        COMMENT = TextAttributesKey.createTextAttributesKey((String)"LESS_COMMENT", (TextAttributesKey)CssHighlighter.CSS_COMMENT);
        TAG_NAME = TextAttributesKey.createTextAttributesKey((String)"LESS_TAG_NAME", (TextAttributesKey)CssHighlighter.CSS_TAG_NAME);
        ID_SELECTOR = TextAttributesKey.createTextAttributesKey((String)"LESS_ID_SELECTOR", (TextAttributesKey)CssHighlighter.CSS_ID_SELECTOR);
        UNICODE_RANGE = TextAttributesKey.createTextAttributesKey((String)"LESS_UNICODE_RANGE", (TextAttributesKey)CssHighlighter.CSS_UNICODE_RANGE);
        PARENTHESES = TextAttributesKey.createTextAttributesKey((String)"LESS_PARENTHESES", (TextAttributesKey)CssHighlighter.CSS_PARENTHESES);
        BRACKETS = TextAttributesKey.createTextAttributesKey((String)"LESS_BRACKETS", (TextAttributesKey)CssHighlighter.CSS_BRACKETS);
        BRACES = TextAttributesKey.createTextAttributesKey((String)"LESS_BRACES", (TextAttributesKey)CssHighlighter.CSS_BRACES);
        DOT = TextAttributesKey.createTextAttributesKey((String)"LESS_DOT", (TextAttributesKey)CssHighlighter.CSS_DOT);
        SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"LESS_SEMICOLON", (TextAttributesKey)CssHighlighter.CSS_SEMICOLON);
        COLON = TextAttributesKey.createTextAttributesKey((String)"LESS_COLON", (TextAttributesKey)CssHighlighter.CSS_COLON);
        COMMA = TextAttributesKey.createTextAttributesKey((String)"LESS_COMMA", (TextAttributesKey)CssHighlighter.CSS_COMMA);
        OPERATORS = TextAttributesKey.createTextAttributesKey((String)"LESS_OPERATORS", (TextAttributesKey)CssHighlighter.CSS_OPERATORS);
        BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"LESS_BAD_CHARACTER", (TextAttributesKey)CssHighlighter.CSS_BAD_CHARACTER);
        mapping = new HashMap<IElementType, TextAttributesKey>();
        mapping.put(LESSTokenTypes.COMMENT, COMMENT);
        mapping.put(CssElementTypes.CSS_HASH, ID_SELECTOR);
        mapping.put(CssElementTypes.CSS_IDENT, IDENTIFIER);
        mapping.put(CssElementTypes.CSS_STRING_TOKEN, STRING);
        mapping.put(CssElementTypes.CSS_NUMBER, NUMBER);
        mapping.put(CssElementTypes.CSS_IMPORTANT, IMPORTANT);
        mapping.put(CssElementTypes.CSS_PROPERTY_NAME, PROPERTY_NAME);
        mapping.put(CssElementTypes.CSS_PROPERTY_VALUE, PROPERTY_VALUE);
        mapping.put(CssElementTypes.CSS_TAG_NAME, TAG_NAME);
        mapping.put(CssElementTypes.CSS_FUNCTION_TOKEN, FUNCTION);
        mapping.put(CssElementTypes.CSS_URI_START, FUNCTION);
        mapping.put(CssElementTypes.CSS_URL, URL);
        mapping.put(CssElementTypes.CSS_COLOR, COLOR);
        mapping.put(CssElementTypes.CSS_PSEUDO, PSEUDO);
        mapping.put(CssElementTypes.CSS_UNICODE_RANGE, UNICODE_RANGE);
        mapping.put(LESSTokenTypes.VARIABLE, VARIABLE);
        mapping.put(LESSTokenTypes.JS_CODE_DELIM, JS_CODE_DELIM);
        mapping.put(LESSTokenTypes.JS_CODE, INJECTED_CODE);
        mapping.put(CssElementTypes.CSS_LPAREN, PARENTHESES);
        mapping.put(CssElementTypes.CSS_RPAREN, PARENTHESES);
        mapping.put(CssElementTypes.CSS_LBRACE, BRACES);
        mapping.put(CssElementTypes.CSS_RBRACE, BRACES);
        mapping.put(CssElementTypes.CSS_LBRACKET, BRACKETS);
        mapping.put(CssElementTypes.CSS_RBRACKET, BRACKETS);
        mapping.put(CssElementTypes.CSS_PERIOD, DOT);
        mapping.put(CssElementTypes.CSS_COLON, COLON);
        mapping.put(CssElementTypes.CSS_COMMA, COMMA);
        mapping.put(CssElementTypes.CSS_SEMICOLON, SEMICOLON);
        mapping.put(CssElementTypes.CSS_BAD_CHARACTER, BAD_CHARACTER);
    }
}

